/* Split.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.enums.activitydef.ActivityDefEnums;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.enums.EnumsUtil;

/**
 * Represents a WfMC DTD element that has the similar name. 活动出口条件
 */
public class Split extends XMLComplexElement {

    private TransitionRefs refTransitionRefs = new TransitionRefs(); // min=0

    private XMLAttribute attrType = new XMLAttribute(EnumsUtil.getAttribute(ActivityDefEnums.Split));

    /**
     * Creates a new instance of the class.
     */
    public Split() {
        super();

        //attrType.setLabelName(ResourceManager.getLanguageDependentString("Activity.ActivityEvent.Split.display"));
        fillStructure();
    }

    /**
     * Defines the super-class method. Read the explanation for this method within XMLComplexElement class.
     */
    protected void fillStructure() {
        if (!complexStructure.contains(attrType)) {
            complexStructure.add(attrType);
        }
        if (complexStructure.contains(refTransitionRefs)) {
            complexStructure.add(refTransitionRefs);
        }

        attributes.add(attrType);

    }

    /**
     * The split is empty if user didn't select AND or XOR.
     */
    public boolean isEmpty() {
        return (attrType.getChoosen().toString().length() == 0);
    }

    public TransitionRefs getRefTransitionRefs() {
        return refTransitionRefs;
    }

    public void setRefTransitionRefs(TransitionRefs refTransitionRefs) {
        this.refTransitionRefs = refTransitionRefs;
    }

    public XMLAttribute getAttrType() {
        return attrType;
    }

    public void setAttrType(XMLAttribute attrType) {
        this.attrType = attrType;
    }

    /**
     * Prepares the panel with a combo box to choose the one of allowed split types.
     *
     * @return XMLPanel to be shown.
     */
    public XMLPanel getPanel() {
        return attrType.getPanel();
    }

    public String getType() {
        return attrType.toValue().toString();
    }

    /**
     * Used to create exact copy of instance of this class. The newly created instance will have all the properties same
     * as the copied one.
     *
     * @return The newly created instance of this class.
     */
    public Object clone() {
        Split s = (Split) super.clone();

        s.attrType = (XMLAttribute) this.attrType.clone();
        s.refTransitionRefs = (TransitionRefs) this.refTransitionRefs.clone();

        s.fillStructure();

        return s;
    }

    public void refreshLabelName() {
        super.refreshLabelName();
        attrType.setLabelName(ResourceManager.getLanguageDependentString("Activity.ActivityEvent.Split.display"));
    }

    public void toXML(Node parent) {
        Element trElem = null;
        NodeList limitList = ((Element) parent).getElementsByTagName("TransitionRestriction");

        if (limitList.getLength() > 0) {
            trElem = (Element) limitList.item(0);
        } else {
            trElem = parent.getOwnerDocument().createElement("TransitionRestriction");
            parent.appendChild(trElem);
        }
        NodeList splitlimitList = trElem.getElementsByTagName("Split");
        if (splitlimitList.getLength() == 0) {
            super.toXML(trElem);
        } else {
            Element spElem = (Element) splitlimitList.item(0);
            spElem.setAttribute("Type", this.getType());
        }


    }

    public void setValue(String val) {
        attrType.setValue(val);
    }
}
