/*
 * Created on 2005-12-24
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2005 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.Iterator;
import java.util.List;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLListControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLListPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.util.XMLUtility;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 流程权限组类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2005
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2005-12-24 16:05:01
 * @version 1.0
 */
public class RightGroups extends XMLCollection {

	// 办理人权限组
	public static final String PERFORMER_GROUP = "PERFORMER";

	// 读者权限组
	public static final String READER_GROUP = "READER";

	// 保存下一个子元素的顺序号
	private int nextOrder = 1;

	/**
	 * 构造器
	 * 
	 * @param myOwner
	 */
	public RightGroups(XMLComplexElement myOwner) {
		super(myOwner);
		setLabelName(ResourceManager
				.getLanguageDependentString("Process.Right.RightGroups.display"));
		// 生成四个权限组
		// 当前办理人组
		RightGroup rgPerformer = (RightGroup) generateNewElement();
		rgPerformer.set("Code", "PERFORMER");
		rgPerformer
				.set(
						"Name",
						ResourceManager
								.getLanguageDependentString("Process.Right.RightGroup.Performer.value"));
		rgPerformer.set("Order", "1");
		rgPerformer.set("DefaultGroup", new String[] { " ", "NORIGHT" });
		add(rgPerformer);
		rgPerformer.setReadOnly(true);
		// 当前读者组
		RightGroup rgReader = (RightGroup) generateNewElement();
		rgReader.set("Code", "READER");
		rgReader
				.set(
						"Name",
						ResourceManager
								.getLanguageDependentString("Process.Right.RightGroup.Reader.value"));
		rgReader.set("Order", "2");
		rgReader.set("DefaultGroup", new String[] { " ", "NORIGHT" });
		add(rgReader);
		rgReader.setReadOnly(true);
		// 历史办理人组
		RightGroup rgHistoryPerformer = (RightGroup) generateNewElement();
		rgHistoryPerformer.set("Code", "HISTORYPERFORMER");
		rgHistoryPerformer
				.set(
						"Name",
						ResourceManager
								.getLanguageDependentString("Process.Right.RightGroup.HistoryPerformer.value"));
		rgHistoryPerformer.set("Order", "3");
		rgHistoryPerformer.set("DefaultGroup", new String[] { " ", "NORIGHT" });
		add(rgHistoryPerformer);
		rgHistoryPerformer.setReadOnly(true);
		// 历史的读者组
		RightGroup rgHistoryReader = (RightGroup) generateNewElement();
		rgHistoryReader.set("Code", "HISTORYREADER");
		rgHistoryReader
				.set(
						"Name",
						ResourceManager
								.getLanguageDependentString("Process.Right.RightGroup.HistoryReader.value"));
		rgHistoryReader.set("Order", "4");
		rgHistoryReader.set("DefaultGroup", new String[] { " ", "NORIGHT" });
		add(rgHistoryReader);
		rgHistoryReader.setReadOnly(true);
	}

	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		RightGroup r = new RightGroup(this);
		r.setRequired(true);
		return r;
	}

	/**
	 * Creates panel which allows user to manipulate with instances of classes
	 * that makes a collection that this class represents. The panel consists of
	 * two sections: XMLListPanel - shows collections' elements, and
	 * XMLListControlPanel - display buttons for manipulating with that
	 * elements.
	 * <p>
	 * NOTE: The order of creation is relevant, first, the controlled panel must
	 * be created, and then the control panel
	 * 
	 * @return DTDPanel to be shown
	 */
	public XMLPanel getPanel() {
		controlledPanel = new XMLListPanel(this, "", false, true, true);
		controlPanel = new XMLListControlPanel(this, "", true, false, true);
		return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel,
				controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
	}

	public void toXML(Node parent) {
		if (!isEmpty() || isRequired()) {
			if (parent != null) {
				String nsURI = ResourceManager
						.getLanguageDependentString("Sys.XML.nsURI");
				Node node = (parent.getOwnerDocument()).createElementNS(nsURI,
						name);
				node.setPrefix(nsURI);
				nextOrder = 1;
				for (Iterator it = refCollectionElements.iterator(); it
						.hasNext();) {
					((XMLElement) it.next()).toXML(node);
					nextOrder();
				}
				parent.appendChild(node);
			}
		}
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		RightGroups r = (RightGroups) super.clone();
		return r;
	}

	public int getNextOrder() {
		return nextOrder;
	}

	private void nextOrder() {
		nextOrder++;
	}

	// 解析XPDL文件保存到流程权限组集合对象
	public void fromXML(Node node) {
		if (node == null) {
			return;
		}
		// 先删除默认信息
		clear();
		List childList = XMLUtility.getChildNodes(node, Node.ELEMENT_NODE);
		for (int i = 0; i < childList.size(); i++) {
			Element child = (Element) childList.get(i);
			XMLElement xmlElem = generateNewElement();
			add(xmlElem);
			xmlElem.fromXML(child);
		}
		// 把默认的流程权限组设成只读
		for (int i = 0; i < refCollectionElements.size(); i++) {
			RightGroup rg = (RightGroup) refCollectionElements.get(i);
			String code = ((XMLAttribute) rg.get("Code")).toValue().toString();
			if (code.equals("PERFORMER") || code.equals("READER")
					|| code.equals("HISTORYPERFORMER")
					|| code.equals("HISTORYREADER")) {
				rg.setReadOnly(true);
			}
		}
	}
}
