/*
 * Created on 2005-12-24
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2005 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.Collection;
import java.util.Iterator;

import com.ds.bpm.enums.right.RightDefEnums;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTextPanel;
import com.ds.enums.EnumsUtil;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 流程权限组元素类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2005
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2005-12-24 16:23:24
 * @version 1.0
 */
public class RightGroup extends XMLCollectionElement {

    private XMLElement groupCode = new XMLAttribute("Code");

    private XMLElement groupName = new XMLAttribute("Name");

    private XMLElement groupOrder = new XMLAttribute("Order");

    private XMLElement defaultGroup = new XMLAttribute(EnumsUtil.getAttribute(RightDefEnums.RIGHTGROUP));

    /**
     * 构造器
     * 
     * @param myCollection
     */
    public RightGroup(XMLCollection myCollection) {
	super(myCollection);
	setLabelName(ResourceManager.getLanguageDependentString("Process.Right.RightGroup.display"));

	// 初始化页面显示信息
	// 权限组Id
	attrId.setLabelName(ResourceManager.getLanguageDependentString("Process.Right.RightGroup.ID.display"));
	attrId.setReadOnly(true);
	// 权限组代码
	groupCode.setRequired(true);
	// 权限组名称
	// 权限组排列顺序
	groupOrder.setLabelName(ResourceManager.getLanguageDependentString("Process.Right.RightGroup.Order.display"));
	// 默认继承权限
	defaultGroup.setLabelName(ResourceManager.getLanguageDependentString("Process.Right.RightGroup.DefaultGroup.display"));
	fillStructure();
    }

    protected void fillStructure() {
	super.fillStructure();
	complexStructure.add(groupCode);
	attributes.add(groupCode);
	complexStructure.add(groupName);
	attributes.add(groupName);
	complexStructure.add(groupOrder);
	attributes.add(groupOrder);
	complexStructure.add(defaultGroup);
	attributes.add(defaultGroup);
    }

    /**
     * 得到RightGroup的显示Panel
     */
    public XMLPanel getPanel() {
	return new XMLGroupPanel(this, new XMLElement[] { attrId, groupCode, groupName, defaultGroup }, "");
    }

    public String toString() {
	return groupName.toString();
    }

    /**
     * 判断权限组代码和名称是否唯一
     * 
     * @return
     */
    public boolean isIDUniqueAndValid(XMLPanel p) {
	Collection allElement = ((XMLCollectionElement) p.getOwner()).getCollection().toCollection();
	// 权限代码唯一
	XMLTextPanel groupCodePanel = (XMLTextPanel) ((XMLGroupPanel) p).getPanel(1);
	// 权限名称唯一
	XMLTextPanel groupNamePanel = (XMLTextPanel) ((XMLGroupPanel) p).getPanel(2);
	if (!isUnique(allElement, groupCodePanel.getText(), "Code", p, groupCode)) {
	    groupCodePanel.getComponent(2).requestFocus();
	    return false;
	}
	if (!isUnique(allElement, groupNamePanel.getText(), "Name", p, groupName)) {
	    groupNamePanel.getComponent(2).requestFocus();
	    return false;
	}
	return true;
    }

    private boolean isUnique(Collection elems, Object value, String Name, XMLPanel p, XMLElement o) {
	for (Iterator it = elems.iterator(); it.hasNext();) {
	    XMLCollectionElement elem = (XMLCollectionElement) it.next();
	    String Id = ((XMLTextPanel) ((XMLGroupPanel) p).getPanel(0)).getText();
	    if (!elem.getID().equals(Id) && elem.get(Name).toValue().toString().equals(value.toString())) {
		XMLPanel.errorMessage(p.getDialog(), ResourceManager.getLanguageDependentString("Sys.ErrorDialog.title"), o.toLabel() + ResourceManager.getLanguageDependentString("Sys.Colon"),
			ResourceManager.getLanguageDependentString("Sys.Collection.isElementExisted"));
		return false;
	    }
	}
	return true;

    }

    public void toXML(Node parent) {
	if (isEmpty() && !isRequired())
	    return;
	if (parent != null) {
	    String nsURI = ResourceManager.getLanguageDependentString("Sys.XML.nsURI");
	    Node node = (parent.getOwnerDocument()).createElementNS(nsURI, name);
	    node.setPrefix(nsURI);
	    RightGroups rgs = (RightGroups) getCollection();
	    int order = rgs.getNextOrder();
	    groupOrder.setValue(String.valueOf(order));
	    for (Iterator it = complexStructure.iterator(); it.hasNext();) {
		XMLElement el = (XMLElement) it.next();
		el.toXML(node);
	    }
	    parent.appendChild(node);
	}
    }

    // 实现clone方法
    public Object clone() {
	RightGroup r = (RightGroup) super.clone();
	r.attrId.setValue(myCollection.generateID());
	r.groupCode = (XMLElement) this.groupCode.clone();
	r.groupName = (XMLElement) this.groupName.clone();
	r.groupOrder = (XMLElement) this.groupOrder.clone();
	r.defaultGroup = (XMLElement) this.defaultGroup.clone();
	r.fillStructure();
	return r;
    }

    // 解析XPDL文件保存到流程权限组对象
    public void fromXML(Node node) {
	super.fromXML(node);
    }
}
