/*
 * Created on 2004-3-28
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLListControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLListPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.enums.right.CommissionEnums;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-3-28 16:54:31
 * @version 1.0
 */
public class ProcessCommissions extends XMLCollection {

    CommissionEnums group;

    /**
     * Constructs a ProcessCommissions instance.
     * 
     * @param myOwner
     */
    public ProcessCommissions(XMLComplexElement myOwner) {
	super(myOwner);
    }

    public CommissionEnums getGroup() {
	return group;
    }

    public void setGroup(CommissionEnums group) {
	this.group = group;
    }

    public ProcessCommissions(XMLComplexElement myOwner, CommissionEnums group) {
	super(myOwner, group.getType());
	setLabelName(group.getName());
	this.group = group;
    }

    /**
     * Generates a new element of the class which instances are members of collection of this class. return The
     * generated instance of class that makes collection.
     */
    public XMLElement generateNewElement() {
	ProcessCommission pc = new ProcessCommission(this);
	pc.setRequired(true);
	return pc;
    }

    public XMLPanel getPanel() {
	controlledPanel = new XMLListPanel(this, "", false, false, false);
	controlPanel = new XMLListControlPanel(this, "", true, false, false);
	return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel, controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
    }
}
