/* Performer.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLSimpleElement;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTextPanel;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class Performer extends XMLSimpleElement {
	/**
	 * Overrides super-class method to realize this class specific writting to
	 * XML file.
	 */
	public void toXML(Node parent) throws DOMException {
		// the Participant object for the performer is held in
		// it's value member - if it isn't, there is no performer
		Object realValue = value;
		if (value instanceof Participant) {
			// prepearing participant ID
			value = ((Participant) value).getID();
		} else {
			if (value.toString().trim().length() == 0) {
				return;
			}
		}
		super.toXML(parent);
		value = realValue;
	}

	/**
	 * Returns the text panel, but do not allow it to update information on
	 * participant used as a performer, because this is done automatically.
	 */
	public XMLPanel getPanel() {
		return new XMLTextPanel(this) {
			public void setElements() {
				if (value instanceof Participant) {
					return;
				} else {
					super.setElements();
				}
			}
		};
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		Performer p = (Performer) super.clone();
		// set the same Participant - (it was cloned to)
		p.setValue(this.toValue());
		return p;
	}

}
