/* PackageHeader.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLComplexElement;

import org.w3c.dom.Node;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class PackageHeader extends XMLComplexElement {
	private XPDLVersion refXPDLVersion = new XPDLVersion();

	private Vendor refVendor = new Vendor();

	private Created refCreated = new Created();

	/**
	 * Creates a new instance of the class.
	 */
	public PackageHeader() {
		super();

		refXPDLVersion.setValue("1.0");
		refVendor.setValue(ResourceManager
				.getLanguageDependentString("Sys.Vendor"));
		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		refXPDLVersion.setRequired(true);
		refXPDLVersion.setReadOnly(true);
		complexStructure.add(refXPDLVersion);
		refVendor.setRequired(true);
		complexStructure.add(refVendor);
		refCreated.setRequired(true);
		complexStructure.add(refCreated);
	}

	public void fromXML(Node node) {
		refCreated.setValue("");
		refXPDLVersion.setValue("");
		refVendor.setValue("");
		super.fromXML(node);
	}

}
