/* Package.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：XML元素的包类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;

import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLComplexChoice;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLInterface;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.bpm.bpd.xml.panels.XMLTextPanel;

/**
 * Represents the main element of WfMC schema. 包对象类，流程XML文件的根节点元素
 */
public class Package extends XMLComplexElement {
	private final static String XMLNS = "http://www.wfmc.org/2005/XPDL2.0";

	private final static String XMLNS_XPDL = "http://www.wfmc.org/2005/XPDL2.0";

	private final static String XMLNS_XSI = "http://www.w3.org/2005/XMLSchema-instance";

	private final static String XSI_SCHEMA_LOCATION = "http://www.wfmc.org/2005/XPDL2.0 http://wfmc.org/standards/docs/TC-1025_schema_20_xpdl.xsd";

	// 自定义的NameSpace
	private final static String XMLNS_CUSTOM_NAME = ResourceManager
			.getLanguageDependentString("Sys.XML.nsURI");

	private final static String XMLNS_CUSTOM_VALUE = ResourceManager
			.getLanguageDependentString("Sys.XML.nsURIValue");

	private PackageHeader refPackageHeader = new PackageHeader();

	private RedefinableHeader refRedefinableHeader = new RedefinableHeader(this);
	
	 private ExternalPackages refExternalPackages=new ExternalPackages(this); // min=0
	// min=0
	private ConformanceClass refConformanceClass = new ConformanceClass();

	// min=0
	private Participants refParticipants;

	// 工作流组元素
	private WorkflowProcesses refWorkflowProcesses = new WorkflowProcesses(this);

	// min=0

	private ExtendedAttributes refExtendedAttributes = new ExtendedAttributes(
			this);

	private Namespaces refNamespaces = new Namespaces(this);

	private XMLAttribute attrId = new XMLAttribute("Id"); // required

	private XMLAttribute attrName = new XMLAttribute("Name");

	/** Used to define a user defined activity properties for the package. */
	private UserProperties userDefinedActivityProperties = new UserProperties(
			this);

	/**
	 * Indicates if this package is made by BPD.
	 */
	private String madeBy = "";

	/**
	 * If this package is made by BPD, indicates it's version.
	 */
	private String version = "";

	private Set allMyExternalPackages = new HashSet();

	private DefaultTreeModel treeModel;

	private DefaultMutableTreeNode myNode;

	/** Enables canceling of changes to the extended attributes collection. */
	private ExtendedAttributes clonedEAs;

	private XMLInterface xmlInterface;

	/**
	 * Creates a new instance of the class.
	 */
	public Package(XMLInterface xmlInterface) {
		super();
		   this.xmlInterface=xmlInterface;
		myNode = new DefaultMutableTreeNode(this);
		treeModel = new DefaultTreeModel(myNode);

		refParticipants = new Participants(this); // min=0

		// create default xpdl namespace attribute
		Namespace xpdlNS = new Namespace();
		xpdlNS.set("Name", "xpdl");
		xpdlNS.set("location", XMLNS_XPDL);
		xpdlNS.setReadOnly(true);
		refNamespaces.add(xpdlNS);
		// create custom namespace attribute
		Namespace customNS = new Namespace();
		customNS.set("Name", XMLNS_CUSTOM_NAME);
		customNS.set("location", XMLNS_CUSTOM_VALUE);
		refNamespaces.add(customNS);

		fillStructure();
	}

	/**
	 * 生成UUID
	 * 
	 * @return
	 */
	private String generateID() {
		return UUID.randomUUID().toString();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		isRequired = true;
		attrId.setRequired(true);
		// 设置Package的属性ID，唯一标识Package
		attrId.setValue(generateID());
		complexStructure.add(attrId);
		attributes.add(attrId);
		complexStructure.add(attrName);
		attributes.add(attrName);
		refPackageHeader.setRequired(true);
		complexStructure.add(refPackageHeader);
		complexStructure.add(refRedefinableHeader);
		complexStructure.add(refConformanceClass);
		complexStructure.add(refParticipants);
		complexStructure.add(refWorkflowProcesses);
		complexStructure.add(refExtendedAttributes);
	    complexStructure.add(refExternalPackages);
	    
	      
	}

	public void setReadOnly(boolean ro) {
		super.setReadOnly(ro);
		userDefinedActivityProperties.setReadOnly(ro);
		refNamespaces.setReadOnly(ro);
	}

	/**
	 * Indicates if package read from XML document) is made by BPD
	 * 
	 * @return <tt>true</tt> if package is made by BPD, <tt>false</tt>
	 *         otherwise.
	 */
	public boolean isMadeByBPD() {
		// return madeBy.equals("BPD");
		return true;
	}

	/**
	 * Indicates which version of BPD was package made by.
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * Indicates which is the current version of BPD.
	 */
	public String getCurrentVersion() {
		return "2.0";
	}

	/**
	 * Collects information about all newly inserted external packages, which
	 * root package is specified one, and which wasn't inserted until now.
	 */
	protected void insertFromExternal(ExternalPackage ep) {
		// all newly inserted packages
		Package extP = xmlInterface.openPackage(ep.toString(), false);
		// set the user.dir to the original
		try {
			System.setProperty("user.dir", xmlInterface.getParentDirectory(this));
		} catch (Exception ex) {
		}
		Set newlyInsertedPackages = extP.allMyExternalPackages;
		newlyInsertedPackages.add(extP);
		newlyInsertedPackages.removeAll(allMyExternalPackages);
		newlyInsertedPackages.remove(this);
		allMyExternalPackages.addAll(newlyInsertedPackages);
		insertFromExternals(newlyInsertedPackages, extP);
	}

	/**
	 * Inserts all required entities from external packages specified within the
	 * set.
	 */
	private void insertFromExternals(Set extPackages, Package beginAt) {
		Iterator it = extPackages.iterator();
		while (it.hasNext()) {
			Package ext = (Package) it.next();
			insertFromExternal(ext);
		}
		if (!isReadOnly()) {
			if (beginAt != null) {
				insertNodeIntoModel(beginAt);
			}
		}

	}

	private void insertFromExternal(Package ep) {
		refParticipants.insertFromExternal(ep);
		refWorkflowProcesses.insertFromExternal(ep);
	}

	public DefaultTreeModel getTreeModel() {
		return treeModel;
	}

	private void insertNodeIntoModel(Package extP) {

		DefaultMutableTreeNode rn = new DefaultMutableTreeNode(extP);
		int hmc = myNode.getChildCount();

		treeModel.insertNodeInto(rn, myNode, hmc);

		insertNodesRecursivly(rn);
	}

	private void insertNodesRecursivly(DefaultMutableTreeNode node) {
		Package insertMyExtPackages = (Package) node.getUserObject();
	}

	private boolean amIAlreadyInserted(DefaultMutableTreeNode dmtn) {
		Object[] userObjects = dmtn.getUserObjectPath();
		Object userObj = dmtn.getUserObject();
		if (userObjects == null || userObjects.length < 2) {
			return false;
		}
		for (int i = 0; i < userObjects.length - 1; i++) {
			if (userObjects[i] == userObj) {
				return true;
			}
		}
		return false;
	}

	/**
	 * Checks if some entities from specified external package (and all packages
	 * that it references - except one that are referenced in some other way
	 * (e.g. cross-reference, or duplicated reference)) are in use by this
	 * package elements.
	 * 
	 * @return <tt>true</tt> if external reference can be removed (case when
	 *         it's entities are not in use), <tt>false</tt> otherwise.
	 */
	protected boolean canRemoveExternalPackage(ExternalPackage ep) {
		Set toCheck = findAllPackagesToRemove(ep);
		// System.out.println("All packages that need to be checked for removal
		// are:"+toCheck);
		Iterator itCheck = toCheck.iterator();
		while (itCheck.hasNext()) {
			Package pkg = (Package) itCheck.next();
			// System.out.println("Checking package "+pkg);
			WorkflowProcesses wps = (WorkflowProcesses) pkg
					.get("WorkflowProcesses");
			Participants ps = (Participants) pkg.get("Participants");
			Applications aps = (Applications) pkg.get("Applications");

			// check if any workflow process that is own directly by package
			// p is referenced from subflow activity
			Iterator it = wps.toCollection().iterator();
			while (it.hasNext()) {
				WorkflowProcess wp = (WorkflowProcess) it.next();
				if (!refWorkflowProcesses.canRemoveElement(wp)) {
					return false;
				}
			}
			// System.out.println("Workflows are not in use");
			// check if any participants are in use
			it = ps.toCollection().iterator();
			while (it.hasNext()) {
				Participant p = (Participant) it.next();
				// The first limitation is due to recursion
				// if (!refParticipants.canRemoveElement(p)) {
				if (!refParticipants.canRemoveParticipant(p)) {
					return false;
				}
			}
			// System.out.println("Participants are not in use");
			// check if any application is in use by the tool of activity
			it = aps.toCollection().iterator();
			while (it.hasNext()) {
				Application app = (Application) it.next();
				// if (!refApplications.canRemoveElement(app)) {
			}
			// System.out.println("Applications are not in use");
		}

		return true;
	}

	protected void removeExternal(ExternalPackage ep) {
		Set toRemove = findAllPackagesToRemove(ep);
		// The top package to remove must be get here,
		// before it is removed from hash table, otherwise
		// the tree node will not be removed
		Package pToRemove = xmlInterface.getExternalPackageByRelativeFilePath(ep
				.toString(), this);
		// System.out.println("All packages that need to be removed
		// are:"+toRemove);
		Iterator itRemove = toRemove.iterator();
		while (itRemove.hasNext()) {
			Package pkg = (Package) itRemove.next();
			// System.out.println("Removing package "+pkg);
			// System.out.println("Apps are removed!");
			refParticipants.removeFromExternal(pkg);
			// System.out.println("Participants are removed!");
			refWorkflowProcesses.removeFromExternal(pkg);
			// System.out.println("Workflows are removed!");
			xmlInterface.closePackage(pkg.get("Id").toString());
			// System.out.println("Model is closed!");
			allMyExternalPackages.remove(pkg);
		}

		// remove node from Jsplit pane tree
		if (pToRemove != null) {
			removeNodeFromModel(pToRemove);
			allMyExternalPackages.remove(pToRemove);
			// System.out.println("Node is removed!");
		}

		// due to a calculating of packages to remove,
		// the reference to removed ext. packes is left
		// so it must be removed
		// refExternalPackages.toCollection().remove(ep);
	}

	private void removeNodeFromModel(Package extP) {
		for (Enumeration e = myNode.children(); e.hasMoreElements();) {
			DefaultMutableTreeNode child = (DefaultMutableTreeNode) e
					.nextElement();
			if (child.getUserObject() == extP) {
				treeModel.removeNodeFromParent(child);
				break;
			}
		}
	}

	private Set findAllPackagesToRemove(ExternalPackage ep) {
		// Find which packages must be checked and removed if user wants
		// to remove given external package reference,
		// the procedure is as follows:
		// 1. Put external package, and all packages that external
		// package references, into one collection
		// 2. Put all external packages and all packages that
		// they are referencing (except the one to be removed)
		// into second collection
		// 3. Find the elements from 1. collection that are contained
		// in 2. collection, and remove it from 1. collection
		// 4. Return packages from 1. collection
		// All this is done because of possible cross-reference of packages

		// 1. step
		Set firstColl = new HashSet();
		Package toRemove = xmlInterface.getExternalPackageByRelativeFilePath(ep
				.toString(), this);
		firstColl.add(toRemove);
		// System.out.println("TRM="+toRemove);
		firstColl.addAll(toRemove.allMyExternalPackages);

		// 2. step
		Set secondColl = new HashSet();
		// first add this main package
		secondColl.add(this);

		// 3. step
		// System.out.println("First coll="+firstColl);
		// System.out.println("Second coll="+secondColl);
		firstColl.removeAll(secondColl);
		// System.out.println("Result coll="+firstColl);
		// 4. step
		return firstColl;
	}

	/**
	 * Returns all user defined activity properties within this package
	 * instance.
	 * 
	 * @return User defined activity properties for Package.
	 */
	public UserProperties getUserDefinedActivityProperties() {
		return userDefinedActivityProperties;
	}

	protected void addPropertyToAllActivities(UserProperty up) {
		refWorkflowProcesses.addPropertyToAllActivities(up);
	}

	protected void removePropertyFromAllActivities(UserProperty up) {
		refWorkflowProcesses.removePropertyFromAllActivities(up);
	}

	protected void refreshMandatories(UserProperty up) {
		refWorkflowProcesses.refreshMandatories(up);
	}

	/**
	 * Returns a workflow process with specified ID.
	 * <p>
	 * NOTE: This method should be called immediately after import of an XML
	 * file (during a creation of graph), otherwise it may not give the desired
	 * result.
	 * 
	 * @param ID
	 *            The 'Id' attribute of wanted instance of WorkflowProcess
	 *            element defined within a XML file.
	 * @return Returns the instance of WorkflowProcess element that have the
	 *         specified ID as an 'Id' attribute if it exist among all defined
	 *         processes within package, if it doesn't exist, <tt>null</tt> is
	 *         returned.
	 */
	public WorkflowProcess getWorkflowProcess(String ID) {
		return refWorkflowProcesses.getWorkflowProcess(ID);
	}

	/**
	 * Overrides super-class method to retreive the value of this class "Id"
	 * attribute. This is used when displaying instance of this class within
	 * dialog.
	 * 
	 * @return The "Id" attribute value of this class.
	 */
	public String toString() {
		return attrId.toString();
	}

	/**
	 * Prepares the one of the group panels that contains some of this element
	 * editable fields.
	 * 
	 * @param no
	 *            The ordinal number of group panel to be shown.
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel(int no) {
		XMLPanel p;
		switch (no) {
		case 1:
			clonedEAs = (ExtendedAttributes) refExtendedAttributes.clone();
			p = new XMLGroupPanel(this, new XMLElement[] { attrId, attrName,
					refConformanceClass, clonedEAs }, XMLUtil
					.getLanguageDependentString("GeneralKey"));
			break;
		case 2:
			p = refPackageHeader.getPanel();
			break;
		case 3:
			p = refRedefinableHeader.getPanel();
			break;
		case 4:
			   p=refExternalPackages.getPanel();
	            break;
		case 5:
		case 6:
			p = refParticipants.getPanel();
			break;
		case 7:
		case 8:
		case 9:
			p = refWorkflowProcesses.getPanel();
			break;
		case 10:
			p = userDefinedActivityProperties.getPanel();
			break;
		case 11:
			p = refNamespaces.getPanel();
			break;
		default:
			p = new XMLPanel();
		}
		return p;
	}

	/**
	 * Prepares the tabbed panel to show editable fields of Package. Panel
	 * consists of nine tabs that logically comprises the Package elements to be
	 * edited.
	 * <p>
	 * NOTE: This method is never used, panels are retrieved one by one calling
	 * the method with the same name but with ordinal number of wanted panel as
	 * an argument.
	 * 
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		XMLPanel[] p = new XMLPanel[11];
		for (int i = 0; i < 11; i++) {
			p[i] = getPanel(i + 1);
		}
		XMLTabbedPanel tp = new XMLTabbedPanel(this, p);

		return tp;
	}

	// It is very important because of our parser to set
	// user defined properties first
	/**
	 * Overrides super-class method to realize this class specific writting to
	 * XML file.
	 * 
	 * @param parent
	 *            The Node of XML file,
	 */
	public void toXML(Node parent) throws DOMException {
		// prepearing extended attributes

		// remove all internally used ext. attribs
		Set easToRemove = new HashSet();
		// ********* user defined activity properties
		Iterator it = userDefinedActivityProperties.toCollection().iterator();
		while (it.hasNext()) {
			UserProperty up = (UserProperty) it.next();
			ExtendedAttribute ea = new ExtendedAttribute(refExtendedAttributes);
			String type = up.get("DataType").toValue().toString();
			DataType dt = new DataType(this);
			XMLComplexChoice t = (XMLComplexChoice) dt.get("Type");
			BasicType bt = (BasicType) t.getChoices()[0];
			XMLElement aT = bt.get("Type");
			aT.setValue(up.get("DataType").toString());
			t.setValue(bt);

			Description d = new Description();
			d.setValue(up.get("Relevance").toValue().toString());
			InitialValue iv = new InitialValue();
			iv.setValue(up.get("DefaultValue").toValue().toString());

			String ID = up.getID();
			ea.set("Name", "ActivitiesUserProperty" + ID);
			ea.set("Value", up.get("Name").toValue().toString());
			XMLCollection c = (XMLCollection) ea.get("Any");
			c.add(dt);
			c.add(d);
			c.add(iv);

			((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
			easToRemove.add(ea);
		}
		// ************ Version ext. attrib.
		ExtendedAttribute ea = new ExtendedAttribute(refExtendedAttributes);
		ea.set("Name", "Version");
		ea.set("Value", getCurrentVersion());
		((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
		easToRemove.add(ea);

		// ************ MadeBy ext. attrib.
		ea = new ExtendedAttribute(refExtendedAttributes);
		ea.set("Name", "MadeBy");
		ea.set("Value", "BPD");
		((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
		easToRemove.add(ea);

		// ******** some stuff to put within attributes
		Node node = ((Document) parent).createElement(name);
		((Element) node).setAttribute("xmlns", XMLNS);
		// ((Element) node).setAttribute("xmlns:xpdl", XMLNS_XPDL);
		// save additional namespaces
		Iterator itNs = refNamespaces.toCollection().iterator();
		while (itNs.hasNext()) {
			Namespace ns = (Namespace) itNs.next();
			((Element) node).setAttribute("xmlns:" + ns.get("Name").toString(),
					ns.get("location").toString());
		}
		((Element) node).setAttribute("xmlns:xsi", XMLNS_XSI);
		((Element) node)
				.setAttribute("xsi:schemaLocation", XSI_SCHEMA_LOCATION);

		for (it = complexStructure.iterator(); it.hasNext();) {
			XMLElement el = (XMLElement) it.next();
			el.toXML(node);
		}
		parent.appendChild(node);

		// removing internally used ext. attribs - otherwise, it would be
		// duplicated
		refExtendedAttributes.toCollection().removeAll(easToRemove);
	}

	/**
	 * Overrides super-class method to realize this class specific reading from
	 * XML file. 把XML Document对象转换成element元素
	 * 
	 * @param node
	 *            The Node of XML file, that represents tag for this element.
	 */
	public void fromXML(Node node) {
		refNamespaces.clear();
		refConformanceClass.set("GraphConformance", "");
		complexStructure.remove(refExtendedAttributes);
		refExtendedAttributes = new ExtendedAttributes(this) {
			public XMLElement generateNewElement() {
				return new ExtendedAttributeForUserProperty((Package) myOwner);
			}
		};
		complexStructure.add(6, refExtendedAttributes);

		processAttributes(node);
		NamedNodeMap attribs = node.getAttributes();
		for (int i = 0; i < attribs.getLength(); i++) {
			Node n = attribs.item(i);
			String nn = n.getNodeName();
			if (nn.startsWith("xmlns:") && !nn.equals("xmlns:xsi")) {
				Namespace ns = new Namespace();
				ns.set("Name", nn.substring(6, nn.length()));
				ns.get("location").fromXML(n);
				refNamespaces.add(ns);
				if (nn.equals("xmlns:xpdl")
						&& ns.get("location").toString().equalsIgnoreCase(
								XMLNS_XPDL)) {
					ns.setReadOnly(true);
				}
			}
		}

		// now, when attributes are parsed, the id of package is known, and the
		// prefix for generating IDs of all collections needs to be set
		attrId.setReadOnly(true);
		setIDPrefixForCollections();

		processElements(node);

		// adjusting extended attrib. (if this is made by PE)
		// remove all internally used ext. attribs
		Set easToRemove = new HashSet();

		// putting user defined properties where they belong
		Iterator it = refExtendedAttributes.toCollection().iterator();
		while (it.hasNext()) {
			ExtendedAttributeForUserProperty eup = (ExtendedAttributeForUserProperty) it
					.next();
			String ID = eup.get("Name").toValue().toString();
			if (ID.startsWith("ActivitiesUserProperty")) {
				try {
					ID = ID.substring("ActivitiesUserProperty".length(), ID
							.length());
					// System.out.println("ID of attr="+ID);
					UserProperty up = new UserProperty(
							userDefinedActivityProperties);
					up.set("Id", ID);
					userDefinedActivityProperties.updateID(ID);
					up.set("Name", eup.get("Value").toValue().toString());

					DataType dt = (DataType) eup.get("DataType");
					XMLComplexChoice t = (XMLComplexChoice) dt.get("Type");
					XMLComplexElement borpt = (XMLComplexElement) t
							.getChoosen();
					XMLAttribute aT = (XMLAttribute) borpt.get("Type");
					up.set("DataType", aT.getChoosen());

					String relevance = ((Description) eup.get("Description"))
							.toValue().toString();
					// System.out.println("Relevance="+relevance);
					relevance = XMLUtil.getLanguageDependentString(relevance
							+ "Key");
					// System.out.println("Relevance(LNGSPEC)="+relevance);
					up.set("Relevance", relevance);
					up.set("DefaultValue", ((InitialValue) eup
							.get("InitialValue")).toValue().toString());

					userDefinedActivityProperties.add(up);
					easToRemove.add(eup);
				} catch (Exception ex) {
				}
			}

			if (ID.equals("MadeBy") && madeBy.length() == 0) {
				madeBy = eup.get("Value").toValue().toString();
				easToRemove.add(eup);
			}
			if (ID.equals("Version") && version.length() == 0) {
				version = eup.get("Value").toValue().toString();
				easToRemove.add(eup);
			}
		}

		// removing internally used ext. attribs - otherwise, it would
		// be shown within ea list
		refExtendedAttributes.toCollection().removeAll(easToRemove);

		// making real extendedAttributes collection (not the collection of
		// ExtendedAttributeForUserProperty)
		Set eas = new HashSet(refExtendedAttributes.toCollection());
		complexStructure.remove(refExtendedAttributes);
		refExtendedAttributes = new ExtendedAttributes(this);
		complexStructure.add(6, refExtendedAttributes);
		it = eas.iterator();
		while (it.hasNext()) {
			ExtendedAttributeForUserProperty eup = (ExtendedAttributeForUserProperty) it
					.next();
			String nm = eup.get("Name").toValue().toString();
			String val = eup.get("Value").toValue().toString();
			String cont = eup.get("ComplexContent").toValue().toString();
			ExtendedAttribute ea = new ExtendedAttribute(refExtendedAttributes);
			ea.set("Name", nm);
			ea.set("Value", val);
			ea.set("ComplexContent", cont);
			refExtendedAttributes.add(ea);
		}

		if (!isMadeByBPD()) {
			userDefinedActivityProperties.clear();
		}
	}

	/**
	 * Sets proper ID prefix for all Id generators (XMLCollection class
	 * instances).
	 */
	public void setIDPrefixForCollections() {
		String idPref = attrId.toValue().toString()
				+ XMLCollectionElement.ID_DELIMITER;
		refParticipants.setIDPrefix(idPref + "Par");
		refWorkflowProcesses.setIDPrefix(idPref + "Wor");

		userDefinedActivityProperties.setIDPrefix(idPref + "UDP");
	}

	/**
	 * Returns a hashtable. The keys are external packages of this package, and
	 * values are Integers that describes the depth of external package within
	 * current package.
	 */
	public Set getAllExternalPackages() {
		return allMyExternalPackages;
	}

	/**
	 * Adds to collection of external packages the all packages that given
	 * external package references.
	 */
	public void addExternalPackages(Package externalPkg) {
		allMyExternalPackages.addAll(externalPkg.allMyExternalPackages);
		allMyExternalPackages.remove(this);
	}

	/**
	 * Adds single external package to collection of external packages.
	 */
	public void addExternalPackage(Package externalPkg) {
		allMyExternalPackages.add(externalPkg);
	}

	/**
	 * Called after importing of XML file to insert entities from external
	 * packages, to set the proper Participant objects for Responsibles of
	 * Package and for every WorkflowProcess within a Package, according on
	 * Responsible ID's read from XML.
	 */
	public void afterImporting() {
		// first import all entities from externaly referenced packages
		// System.out.println("After imporing for package "+toString()+" is
		// called");
		// System.out.println("I am pkg "+toString()+", my ext
		// pkgs="+allMyExternalPackages);
		insertFromExternals(allMyExternalPackages, null);

		refRedefinableHeader.afterImporting();

		// adjusting external packages
		// refExternalPackages.afterImporting();

		// adjusting responsibles for each workflow process,
		// performer for each activity within workflow process
		// and collecting workflow process information
		Iterator it = refWorkflowProcesses.toCollection().iterator();
		while (it.hasNext()) {
			WorkflowProcess wp = (WorkflowProcess) it.next();
			// collecting workflow process information
			wp.afterImporting(true);
		}

	}

	public void refreshLabelName() {
		super.refreshLabelName();
		userDefinedActivityProperties.refreshLabelName();
	}

	public boolean isValidEnter(XMLPanel p) {
		// must be set in try-catch block because the panel
		// can be either XMLTabbedPanel or XMLGroupPanel
		try {
			XMLTextPanel tp = (XMLTextPanel) ((XMLGroupPanel) p).getPanel(0);
			String IDToCheck = tp.getText();
			if (!XMLCollection.isIdValid(IDToCheck)) {
				String message = XMLUtil
						.getLanguageDependentString("ErrorIDMustBeValid");
				String dialogTitle = XMLUtil
						.getLanguageDependentString("DialogIDIsNotValid");
				XMLPanel.errorMessage(p.getDialog(), dialogTitle, "", message);
				((JTextField) tp.getComponent(2)).requestFocus();
				return false;
			}
		} catch (Exception ex) {
		}
		try {
			if (!refRedefinableHeader.isValidEnter(((XMLTabbedPanel) p)
					.getTabbedPanel(2))) {
				return false;
			}
		} catch (Exception ex) {
		}
		if (clonedEAs != null) {
			complexStructure.remove(refExtendedAttributes);
			refExtendedAttributes = clonedEAs;
			complexStructure.add(12, refExtendedAttributes);
		}
		return true;
	}

	// 实现equals方法
	public boolean equals(Object o) {
		if (o == null || !(o instanceof Package)) {
			return false;
		}
		if (o == this) {
			return true;
		}
		Package tmp = (Package) o;
		return tmp.get("Id").toValue().toString().equals(
				this.get("Id").toValue().toString());
	}
	 public XMLInterface getXMLInterface () {
	      return xmlInterface;
	   }
}
