/* ExtendedAttribute.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import javax.swing.JTextField;

import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTextPanel;

/**
 * Helper class.
 */
public class Namespace extends XMLComplexElement {
	private XMLAttribute attrName = new XMLAttribute("Name"); // required

	private XMLAttribute attrLocation = new XMLAttribute("location"); // required

	/**
	 * Creates a new instance of the class.
	 */
	public Namespace() {
		super();

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		attrName.setRequired(true);
		attrLocation.setRequired(true);
		complexStructure.add(attrName);
		attributes.add(attrName);
		complexStructure.add(attrLocation);
		attributes.add(attrLocation);
	}

	/**
	 * Prepares the panel for showing extended attribute of some XML element.
	 * 
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		return new XMLGroupPanel(this, new XMLElement[] { attrName,
				attrLocation }, toLabel());
	}

	public String toString() {
		String toRet = XMLUtil.getLanguageDependentString("NameKey") + "="
				+ attrName.toString() + ", "
				+ XMLUtil.getLanguageDependentString("locationKey") + "="
				+ attrLocation.toString();
		if (toRet == null) {
			return "";
		} else {
			return toRet;
		}
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		Namespace ns = (Namespace) super.clone();
		ns.attrName = (XMLAttribute) this.attrName.clone();
		ns.attrLocation = (XMLAttribute) this.attrLocation.clone();
		ns.fillStructure();
		return ns;
	}

	/**
	 * This method checks if the value of the name attribute is valid.
	 */
	public boolean isValidEnter(XMLPanel p) {
		XMLGroupPanel gp = (XMLGroupPanel) p;
		try {
			XMLTextPanel tp = (XMLTextPanel) gp.getPanel(0);
			String nameToCheck = tp.getText();
			if (!XMLCollection.isIdValid(nameToCheck)) {
				String message = XMLUtil
						.getLanguageDependentString("ErrorValueIsNotValid");
				String dialogTitle = XMLUtil.getLanguageDependentString("Title");
				XMLPanel.errorMessage(p.getDialog(), dialogTitle, attrName
						.toLabel()
						+ ": ", message);
				((JTextField) tp.getComponent(2)).requestFocus();
				return false;
			}
		} catch (Exception ex) {
		}

		return true;
	}

}
