/* Member.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexChoice;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class Member extends XMLComplexElement {
	private DataTypes refType;

	/**
	 * Creates a new instance of the class.
	 */
	public Member(Package p) {
		super();

		refType = new DataTypes(this, p, null, 0);
		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		refType.setRequired(true);
		complexStructure.add(refType);
	}

	/**
	 * Returns the value of choosen type.
	 * 
	 * @return The value of choosen member type.
	 */
	public Object toValue() {
		return refType.toValue();
	}

	/**
	 * Overrides parent method to display the choosen type. It displays data
	 * type details for BasicType and for DeclaredType.
	 */
	public String toString() {
		Object type = refType.toValue();
		if (type instanceof BasicType) {
			return refType.toString()
					+ " - "
					+ ((XMLAttribute) ((BasicType) type).get("Type"))
							.getChoosen().toString();
		} else if (type instanceof DeclaredType) {
			return refType.toString()
					+ " - "
					+ ((XMLComplexChoice) ((DeclaredType) type).get("SubType"))
							.getChoosen().toString();
		} else {
			return refType.toString();
		}
	}

	/**
	 * Prepares the panel with a combo box to choose the one of allowed member
	 * types.
	 * 
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		return refType.getPanel();
	}

}
