/*
 * Created on 2005-12-26
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2005 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.Iterator;
import java.util.List;

import org.w3c.dom.Node;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTableControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLTablePanel;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 工作流监听器类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2006
 * </p>
 * <p>
 * Company: jdsbpm
 * </p>
 * 
 * @author wenzhangli
 * @version 2.0
 */
public class Listeners extends XMLCollection {

	/**
	 * 构造器
	 * 
	 * @param myOwner
	 */
	public Listeners(XMLComplexElement myOwner) {
		super(myOwner);
		setLabelName(ResourceManager
				.getLanguageDependentString("Process.Listener.display"));
	}

	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		Listener l = new Listener(this);
		l.setRequired(true);
		return l;
	}

	/**
	 * Creates panel which allows user to manipulate with instances of classes
	 * that makes a collection that this class represents. The panel consists of
	 * two sections: XMLListPanel - shows collections' elements, and
	 * XMLListControlPanel - display buttons for manipulating with that
	 * elements.
	 * <p>
	 * NOTE: The order of creation is relevant, first, the controlled panel must
	 * be created, and then the control panel
	 * 
	 * @return DTDPanel to be shown
	 */
	public XMLPanel getPanel() {
		controlledPanel = new XMLTablePanel(this, "", false, false, true);
		controlPanel = new XMLTableControlPanel(this, "", true, false);
		return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel,
				controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
	}

	public void toXML(Node parent) {
		if (!isEmpty() || isRequired()) {
			if (parent != null) {
				String nsURI = ResourceManager
						.getLanguageDependentString("Sys.XML.nsURI");
				Node node = (parent.getOwnerDocument()).createElementNS(nsURI,
						name);
				node.setPrefix(nsURI);
				for (Iterator it = refCollectionElements.iterator(); it
						.hasNext();) {
					((XMLElement) it.next()).toXML(node);
				}
				
				parent.appendChild(node);
			}
		}
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		Listeners l = (Listeners) super.clone();
		return l;
	}

	public int[] getInvisibleTableFieldOrdinals() {
		return new int[] { 0 };
	}

	public List getProcessListeners() {
		if (getOwner() instanceof WorkflowProcess) {
			return ((WorkflowProcess) getOwner()).getProcessListeners();
		} else if (getOwner() instanceof Activity){
			return ((Activity) getOwner()).getOwnerProcess()
					.getProcessListeners();
		}else {
			return ((Transition) getOwner()).getOwnerProcess()
			.getProcessListeners();
		}
	}

	public List getActivityListeners() {
		if (getOwner() instanceof WorkflowProcess) {
			return ((WorkflowProcess) getOwner()).getActivityListeners();
		} else if (getOwner() instanceof Activity){
			return ((Activity) getOwner()).getOwnerProcess()
					.getActivityListeners();
		}else {
			return ((Transition) getOwner()).getOwnerProcess()
			.getActivityListeners();
		}
	}

	public void afterImporting() {
		for (Iterator it = toCollection().iterator(); it.hasNext();) {
			Listener l = (Listener) it.next();
			l.afterImporting();
		}
	}
}
