/* ListType.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class ListType extends XMLComplexElement {
	private DataTypes refType;

	private DataTypes myOwner;

	/**
	 * Creates a new instance of the class.
	 */
	public ListType(DataTypes dtc, Package p) {
		super();

		myOwner = dtc;
		refType = new DataTypes(this, p, null, 0);
		refType.setLabelName(XMLUtil.getLanguageDependentString("SubTypeKey"));
		fillStructure();
	}

	public DataTypes getOwner() {
		return myOwner;
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		refType.setRequired(true);
		complexStructure.add(refType);
	}

	/**
	 * Returns the value of choosen type.
	 * 
	 * @return The value of choosen list type.
	 */
	public Object toValue() {
		return refType.toValue();
	}

	/**
	 * Prepares the panel with a combo box to choose the one of allowed list
	 * types.
	 * 
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		return refType.getPanel();
	}

	public void refreshLabelName() {
		super.refreshLabelName();
		refType.setLabelName(XMLUtil.getLanguageDependentString("SubTypeKey"));
	}

}
