/* Join.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.enums.activitydef.ActivityDefEnums;
import com.ds.enums.EnumsUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Represents a WfMC DTD element that has the similar name. 活动入口条件
 */
public class Join extends XMLComplexElement {

    public XMLAttribute attrType = new XMLAttribute(EnumsUtil.getAttribute(ActivityDefEnums.Join));

    /**
     * Creates a new instance of the class.
     */
    public Join() {
        super();

        fillStructure();
    }

    /**
     * Defines the super-class method. Read the explanation for this method within XMLComplexElement class.
     */
    protected void fillStructure() {

        if (!complexStructure.contains(attrType)) {
            complexStructure.add(attrType);
        }
        attributes.add(attrType);

    }

    public String getType() {

        return attrType.toValue().toString();
    }

    /**
     * The join is empty if user didn't select AND or XOR.
     */
    public boolean isEmpty() {
        return (attrType.getChoosen().toString().length() == 0);
    }

    /**
     * Prepares the panel with a combo box to choose the one of allowed join types.
     *
     * @return XMLPanel to be shown.
     */
    public XMLPanel getPanel() {
        return attrType.getPanel();
    }

    /*
     * public XMLPanel getPanel () { return new XMLGroupPanel(this,new Object[] {attrType.getPanel()},
     * XML.getResourceString("PreconditionKey")); }
     */

    /**
     * Used to create exact copy of instance of this class. The newly created instance will have all the properties same
     * as the copied one.
     *
     * @return The newly created instance of this class.
     */
    public Object clone() {
        Join j = (Join) super.clone();

        j.attrType = (XMLAttribute) this.attrType.clone();
        j.fillStructure();
        return j;
    }

    public void refreshLabelName() {
        super.refreshLabelName();

    }

    public void toXML(Node parent) {
        Element trElem = null;
        NodeList limitList = ((Element) parent).getElementsByTagName("TransitionRestriction");

        if (limitList.getLength() > 0) {
            trElem = (Element) limitList.item(0);
        } else {
            trElem = parent.getOwnerDocument().createElement("TransitionRestriction");
            parent.appendChild(trElem);
        }
        NodeList splitlimitList = trElem.getElementsByTagName("Join");
        if (splitlimitList.getLength() == 0) {
            super.toXML(trElem);
        } else {
            Element spElem = (Element) splitlimitList.item(0);
            spElem.setAttribute("Type", this.getType());
        }
    }

    public void setValue(String val) {
        attrType.setValue(val);
    }
}
