/* Implementation.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import org.w3c.dom.Node;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLComplexChoice;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.activity.Devices;
import com.ds.bpm.bpd.xml.activity.Events;
import com.ds.bpm.bpd.xml.activity.No;
import com.ds.bpm.bpd.xml.activity.OutFlow;
import com.ds.bpm.bpd.xml.activity.Services;
import com.ds.bpm.bpd.xml.activity.SubFlow;
import com.ds.bpm.bpd.xml.activity.Tools;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name. 活动实现类型类
 * 
 * @see XML
 */
public class Implementation extends XMLComplexElement {
	// we use tools instead of tool
	private XMLComplexChoice refType;

	/**
	 * Creates a new instance of the class.
	 * 
	 * @param act
	 *            The activity that holds this object.
	 */
	public Implementation(Activity act) {
		super();

		/**
		 * NOTE: Here we use the helper class Tools, which does not have it's
		 * WfMC DTD equivalent, as one of possible types.
		 */
		try {
			refType = new XMLComplexChoice("Type", new XMLElement[] {
					new Tools(act), new No(act), new SubFlow(act),
					new BlockActivity(act), new OutFlow(act), new Services(act),new Devices(act),new Events(act) }, 1, true);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		refType.setRequired(true);
		complexStructure.add(refType);
	}

	/**
	 * Overrides super-class method to realize this class specific reading from
	 * XML file.
	 * 
	 * @param tagContent
	 *            The content retrieved from XML file, that represents tag for
	 *            this element.
	 */
	public void fromXML(Node node) {
		String nameSpacePrefix = node.getPrefix();
		if (nameSpacePrefix != null) {
			nameSpacePrefix += ":";
		} else {
			nameSpacePrefix = "";
		}

		Object[] choices = refType.getChoices();
		String elContent;
		String elName;
		// Iterating through implementation types, and performing
		// a parsing to retrieve the tag for type, if tag was
		// found, setting it to be a choosen one for implementation
		// and calling it's fromXML method
		for (int i = 0; i < choices.length; i++) {
			XMLElement chc = (XMLElement) choices[i];
			elName = chc.toName();
			if (elName.equals("Tools")) {
				elName = "Tool";
			}
			// external parser
			if (node != null) {
				Node child = XMLUtil.getChildByName(node, nameSpacePrefix + elName);
				if (child != null) {
					if (elName.equals("Tool")) {
						chc.fromXML(node);
					} else {
						chc.fromXML(child);
					}
					refType.setValue(chc);
					break;
				}
			}
		}
	}

	/**
	 * Prepares the panel with a combo box to choose the one of types of
	 * implementation.
	 * 
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		return refType.getPanel();
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		Implementation i = (Implementation) super.clone();

		i.refType = (XMLComplexChoice) this.refType.clone();
		i.fillStructure();

		return i;
	}

}
