/* FinishMode.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLComplexChoice;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.panels.XMLComboPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

import org.w3c.dom.Node;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class FinishMode extends XMLComplexElement {

	private boolean fromXMLExecuted = false;

	private XMLComplexChoice refMode = new XMLComplexChoice(name,
			new XMLElement[] { new Empty(), new Automatic(), new Manual() }, 1) {
		public XMLPanel getPanel() {
			return new XMLComboPanel(this);
		}
	};

	/**
	 * Creates a new instance of the class.
	 */
	public FinishMode() {
		super();

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		// refMode.setRequired(true);
		complexStructure.add(refMode);
	}

	public void fromXML(Node node) {
		fromXMLExecuted = true;
		refMode.setValue(refMode.getChoices()[0]);
		super.fromXML(node);
	}

	protected void afterImporting() {
		if (!fromXMLExecuted) {
			refMode.setValue(refMode.getChoices()[0]);
		}
	}

	/**
	 * The finish mode is empty if user didn't select Automatic or Manual.
	 */
	public boolean isEmpty() {
		return (refMode.getChoosen() instanceof Empty);
	}

	/**
	 * Prepares the panel with a combo box to choose the one of allowed finish
	 * modes.
	 * 
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		return refMode.getPanel();
	}

	/**
	 * Overrides the super class method to return the value of the choosen mode.
	 * 
	 * @return The value of choosen finish mode.
	 */
	public Object toValue() {
		return refMode.toValue();
	}

	/**
	 * Overrides super-class method to retreive the choosen mode. This is used
	 * when displaying instance of this class within combo box.
	 * 
	 * @return The type of finishing mode.
	 */
	public String toString() {
		return refMode.toString();
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		FinishMode fm = (FinishMode) super.clone();

		fm.refMode = (XMLComplexChoice) this.refMode.clone();
		fm.fillStructure();

		return fm;
	}

}
