/* ExternalReference.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class ExternalReference extends XMLComplexElement {
	private XMLAttribute attrXref = new XMLAttribute("xref"); // optional

	private XMLAttribute attrLocation = new XMLAttribute("location", 1); // required

	private XMLAttribute attrNamespace = new XMLAttribute("namespace", 1); // optional

	/**
	 * Creates a new instance of the class.
	 */
	public ExternalReference() {
		super();

		// isRequired=true;
		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		complexStructure.add(attrXref);
		attributes.add(attrXref);
		attrLocation.setRequired(true);
		complexStructure.add(attrLocation);
		attributes.add(attrLocation);
		complexStructure.add(attrNamespace);
		attributes.add(attrNamespace);
	}

}
