/* ExtendedAttributeForUserProperty.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLUtil;

import org.w3c.dom.Node;

/**
 * This is not a real WfMC DTD element, but it is introduced to help. It is used
 * when reading user defined activity properties from an XML file.
 */
public class ExtendedAttributeForUserProperty extends XMLComplexElement {
	private XMLAttribute attrName = new XMLAttribute("Name"); // required

	private XMLAttribute attrValue = new XMLAttribute("Value");

	private DataType refDataType;

	private Description refDescription = new Description();

	private InitialValue refInitialValue = new InitialValue();

	private ComplexContent refComplexContent;

	/**
	 * Creates a new instance of the class.
	 * 
	 * @param p
	 *            The package for this element.
	 */
	public ExtendedAttributeForUserProperty(Package p) {
		super();

		name = "ExtendedAttribute";
		refDataType = new DataType(p);
		refComplexContent = new ComplexContent(p);
		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		complexStructure.add(attrName);
		attributes.add(attrName);
		complexStructure.add(attrValue);
		attributes.add(attrValue);
		complexStructure.add(refDataType);
		complexStructure.add(refDescription);
		complexStructure.add(refInitialValue);
		complexStructure.add(refComplexContent);
	}

	public void fromXML(Node node) {
		super.fromXML(node);
		if (node != null && node.hasChildNodes()) {
			String txt = XMLUtil.getChildNodesContent(node);
			refComplexContent.setValue(txt);
		}
	}

}
