/* EnumerationValue.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import javax.swing.JTextField;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTextPanel;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class EnumerationValue extends XMLComplexElement {
	private XMLAttribute attrName = new XMLAttribute("Name"); // required

	/**
	 * Creates a new instance of the class.
	 */
	public EnumerationValue() {
		super();

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		attrName.setRequired(true);
		complexStructure.add(attrName);
		attributes.add(attrName);
	}

	/**
	 * Overrides the super class method to return the value of it's "Name"
	 * attribute value.
	 * 
	 * @return The value of this class "Name" attribute.
	 */
	public Object toValue() {
		return attrName.toValue();
	}

	/**
	 * Overrides super-class method to retreive the value of this class "Name"
	 * attribute. This is used when displaying instance of this class within
	 * dialog.
	 * 
	 * @return The "Name" attribute value of this class.
	 */
	public String toString() {
		return attrName.toString();
	}

	/**
	 * This method checks if the value of the name attribute is valid.
	 */
	public boolean isValidEnter(XMLPanel p) {
		XMLGroupPanel gp = (XMLGroupPanel) p;
		try {
			XMLTextPanel tp = (XMLTextPanel) gp.getPanel(0);
			String nameToCheck = tp.getText();
			if (!XMLCollection.isIdValid(nameToCheck)) {
				String message = XMLUtil
						.getLanguageDependentString("ErrorValueIsNotValid");
				String dialogTitle = XMLUtil.getLanguageDependentString("Title");
				XMLPanel.errorMessage(p.getDialog(), dialogTitle, attrName
						.toLabel()
						+ ": ", message);
				((JTextField) tp.getComponent(2)).requestFocus();
				return false;
			}
		} catch (Exception ex) {
		}

		return true;
	}

}
