/* Description.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Description：XML元素描述类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.elements;

import javax.swing.tree.DefaultMutableTreeNode;

import com.ds.bpm.bpd.xml.ToNameMutableTreeNode;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSimpleElement;
import com.ds.bpm.bpd.xml.panels.XMLMultiLineTextPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see com.ds.bpm.bpd.xml.XML
 */
public class Description extends XMLSimpleElement {

	private boolean miniDimension = false;
	private boolean bigDimension;

	public Description() {
		super();
	}

	public Description(boolean miniDimension) {
		this.miniDimension = miniDimension;
	}
	public Description(boolean miniDimension,boolean bigDimension) {
		this.bigDimension = bigDimension;
	}
	/**
	 * Prepares the panel for entering/reading description of some XML element.
	 * This panel alowes entering of multiple lines of text.
	 * 
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		if (bigDimension) {
			return new XMLMultiLineTextPanel(this, XMLPanel.BOX_LAYOUT, true, false, true, false);
		}
		if (miniDimension) {
			return new XMLMultiLineTextPanel(this, true);
		} else {
			return new XMLMultiLineTextPanel(this);
		}
	}

	   public DefaultMutableTreeNode getNode() {
	      return new ToNameMutableTreeNode( this ) {
	         public String toString() {
	            if ( this.userObject == null )
	               return null;
	            String name = ( ( XMLElement ) userObject ).toName();
	            return name;
	         }
	      };
	   }
}
