/* DeclaredType.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLComplexChoice;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLComboButtonPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class DeclaredType extends XMLComplexElement {
	/** Reference to all types declared within this elements package */
	private transient TypeDeclarations declaredTypes = null;

	private XMLAttribute attrId = new XMLAttribute("Id"); // required

	/** Used to hold reference to the choosen TypeDeclaration. */
	private transient XMLComplexChoice helperElement;

	/**
	 * Creates a new instance of the class.
	 * 
	 * @param p
	 *            The package which elements holds instance of of this class.
	 */
	public DeclaredType(Package p) {
		super();

		try {
			declaredTypes = (TypeDeclarations) p.get("TypeDeclarations");
		} catch (NullPointerException npe) {
			//
		}

		helperElement = new XMLComplexChoice("SubType", null, 0) {
			public XMLPanel getPanel() {
				if (declaredTypes != null) {
					choices = declaredTypes.toCollection().toArray();
					try {
						// this is important after reading from XML the
						// declared type that uses another declared type
						this.setValue(declaredTypes.getDeclaredType(attrId
								.toValue().toString()));
					} catch (Exception ex) {
						//
					}
				} else {
					choices = null;
				}
				return new XMLComboButtonPanel(this, declaredTypes);
			}

			public void setReadOnly(boolean ro) {
				this.isReadOnly = ro;
			}

			public void setValue(Object v) {
				super.setValue(v);
				try {
					attrId.setValue(((XMLCollectionElement) this.getChoosen())
							.getID());
				} catch (Exception ex) {
				}
			}

		};

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		attrId.setRequired(true);
		attributes.add(attrId);
		complexStructure.add(attrId);
		helperElement
				.setLabelName(XMLUtil.getLanguageDependentString("SubTypeKey"));
		helperElement.setRequired(true);
		complexStructure.add(helperElement);
	}

	/**
	 * Overrides super-class method to realize this class specific writting to
	 * XML file.
	 * 
	 * @return The string for a WfMC DTD DeclaredType element tag.
	 */
	public void toXML(Node parent) throws DOMException {
		// setting attribute Id to be the one of the choosen TypeDeclaration
		// we must remove helper element after that, generate xml output and
		// put the helper element and old value for attribute Id back.
		Object val = attrId.toValue();
		complexStructure.remove(1);
		super.toXML(parent);
		complexStructure.add(1, helperElement);
	}

	/**
	 * Overrides super-class method to realize this class specific reading from
	 * XML file.
	 * 
	 * @param tagContent
	 *            The content retrieved from XML file, that represents tag for
	 *            this element.
	 */
	public void fromXML(Node node) {
		super.fromXML(node);
		// initializes helper element to TypeDeclaration with given Id
		helperElement.setValue(declaredTypes.getDeclaredType(attrId.toValue()
				.toString()));
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		DeclaredType dt = (DeclaredType) super.clone();
		dt.helperElement = new XMLComplexChoice("SubType", null, 0) {
			public XMLPanel getPanel() {
				if (declaredTypes != null) {
					choices = declaredTypes.toCollection().toArray();
				} else {
					choices = null;
				}
				return new XMLComboButtonPanel(this, declaredTypes);
			}
		};
		dt.helperElement.setValue(helperElement.getChoosen());

		dt.declaredTypes = this.declaredTypes;

		dt.fillStructure();

		return dt;
	}

	/**
	 * Prepares the panel with a combo box to choose the one of already
	 * user-declared types.
	 * 
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		return helperElement.getPanel();
	}

}
