/* ConformanceClass.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name.
 */
public class ConformanceClass extends XMLComplexElement {

	private XMLAttribute attrGraphConformance = new XMLAttribute(
			"GraphConformance", new String[] { "", "FULL_BLOCKED",
					"LOOP_BLOCKED", "NON_BLOCKED" }, 1);

	/**
	 * Creates a new instance of the class.
	 */
	public ConformanceClass() {
		super();

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		complexStructure.add(attrGraphConformance);
		attributes.add(attrGraphConformance);
	}

	/**
	 * Prepares the panel with a combo box to choose the one of allowed types of
	 * graph conformance.
	 * 
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		return attrGraphConformance.getPanel();
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		ConformanceClass c = (ConformanceClass) super.clone();

		c.attrGraphConformance = (XMLAttribute) this.attrGraphConformance
				.clone();
		c.fillStructure();

		return c;
	}

}
