/*
 * Created on 2005-12-26
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2005 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.w3c.dom.Node;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.plugin.impl.activity.ActivityCommand;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTableControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLTablePanel;

public class CommandListeners extends XMLCollection {

	/**
	 * 构造器
	 * 
	 * @param myOwner
	 */
	public CommandListeners(XMLComplexElement myOwner) {
		super(myOwner);
		setLabelName(ResourceManager
				.getLanguageDependentString("Activity.command.Listener.display"));
	}

	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		CommandListener l = new CommandListener(this);
		l.setRequired(true);
		return l;
	}

	/**
	 * Creates panel which allows user to manipulate with instances of classes
	 * that makes a collection that this class represents. The panel consists of
	 * two sections: XMLListPanel - shows collections' elements, and
	 * XMLListControlPanel - display buttons for manipulating with that
	 * elements.
	 * <p>
	 * NOTE: The order of creation is relevant, first, the controlled panel must
	 * be created, and then the control panel
	 * 
	 * @return DTDPanel to be shown
	 */
	public XMLPanel getPanel() {
		controlledPanel = new XMLTablePanel(this, "", false, false, true);
		controlPanel = new XMLTableControlPanel(this, "", true, false);
		return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel,
				controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
	}

	public void toXML(Node parent) {
		if (!isEmpty() || isRequired()) {
			if (parent != null) {
				String nsURI = ResourceManager
						.getLanguageDependentString("Sys.XML.nsURI");
				Node node = (parent.getOwnerDocument()).createElementNS(nsURI,
						name);
				node.setPrefix(nsURI);
				for (Iterator it = refCollectionElements.iterator(); it
						.hasNext();) {
					((XMLElement) it.next()).toXML(node);
				}
				
				parent.appendChild(node);
			}
		}
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		CommandListeners l = (CommandListeners) super.clone();
		return l;
	}

	public int[] getInvisibleTableFieldOrdinals() {
		return new int[] { 0 };
	}



	public List getActivityListeners() {
		if (getOwner() instanceof WorkflowProcess) {
			return ((WorkflowProcess) getOwner()).getActivityListeners();
		} else if (getOwner() instanceof Activity){
			return ((Activity) getOwner()).getOwnerProcess()
					.getActivityListeners();
		} else if (getOwner() instanceof Transition){
			return ((Transition) getOwner()).getOwnerProcess()
			.getActivityListeners();
		} else if (getOwner() instanceof ActivityCommand){
			 return ((ActivityCommand) getOwner()).getProcess().getActivityCommandListeners();
		}else{
			
			return new ArrayList();
		}
	}

	public void afterImporting() {
		for (Iterator it = toCollection().iterator(); it.hasNext();) {
			Listener l = (Listener) it.next();
			l.afterImporting();
		}
	}
}
