/* BlockActivity.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：跳转流程活动XML元素类
 * Authors： wenzhang li
 * Company： 基督山BPM
 *  CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;

import com.ds.bpm.enums.activitydef.ActivityDefEnums;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLComplexChoice;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.panels.XMLComboPanel;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.util.XMLUtility;
import com.ds.enums.EnumsUtil;

/**
 * Represents a WfMC DTD element that has the similar name. 外流程活动
 * 
 * @see XML
 */
public class BlockActivity extends XMLComplexElement {

    private XMLAttribute attrId = new XMLAttribute("Id"); // required
    private XMLAttribute verId = new XMLAttribute("VerId"); // required

    private XMLAttribute attrExecution = new XMLAttribute(EnumsUtil.getAttribute(ActivityDefEnums.Execution));

    private transient Package myPackage = null;

    private transient WorkflowProcess myWP = null;

    private transient Activity myAct = null;

    /** Choice of possible workflows. */
    private transient XMLComplexChoice helperElement;

    /**
     * Creates a new instance of the class.
     */
    public BlockActivity() {
	super();

	fillStructure();
    }

    /**
     * 带活动参数的构造器
     * 
     * @param act
     */
    public BlockActivity(Activity act) {
	super();
	// 初始化页面显示属性
	setLabelName(ResourceManager.getLanguageDependentString("Activity.General.Type.Block.value"));
	attrExecution.setLabelName(ResourceManager.getLanguageDependentString("Activity.Block.Execution.display"));
	myAct = act;
	if (myAct != null) {
	    myWP = myAct.getOwnerProcess();
	    myPackage = myWP.getPackage();
	}

	helperElement = new XMLComplexChoice("WorkflowProcess", null, 0) {
	    public XMLPanel getPanel() {
		WorkflowProcesses wps = null;
		if (myPackage != null) {
		    wps = (WorkflowProcesses) myPackage.get("WorkflowProcesses");
		    ArrayList ws = new ArrayList();
		    ws.addAll(myAct.getOwnerProcess().getActivitySets().toCollection());
		    ws.remove(myWP);
		    if (ws.size() == 0) {
			choices = null;
		    } else {
			choices = ws.toArray();
		    }
		} else {
		    choices = null;
		}
		this.setValue(attrId.toValue());

		if (this.getChoosen() == null && choices != null && helperElement.getChoosen() != null) {
		    attrId.setValue(((XMLCollectionElement) helperElement.getChoosen()).getID());
		    // this.setValue(choices[0]);
		}
		return new XMLComboPanel(this, choices);
	    }

	    public void setValue(Object v) {
		super.setValue(v);
		try {
		    attrId.setValue(((XMLCollectionElement) this.getChoosen()).getID());
		} catch (Exception ex) {
		}
	    }

	};
	helperElement.setLabelName(ResourceManager.getLanguageDependentString("Activity.Block.DestProcess.display"));
	helperElement.setRequired(true);
	helperElement.setReadOnly(true);

	// attrId.setValue("-1");
	fillStructure();

    }

    public String getAttrId() {
	return attrId.toString();

    }

    /**
     * Defines the super-class method. Read the explanation for this method within XMLComplexElement class.
     */
    protected void fillStructure() {
	attrId.setRequired(true);
	attrId.setReadOnly(true);

	verId.setRequired(true);
	verId.setReadOnly(true);

	complexStructure.add(attrId);
	complexStructure.add(verId);
	attributes.add(attrId);
	attributes.add(verId);
	helperElement.setRequired(true);
	// complexStructure.add(helperElement);
	complexStructure.add(attrExecution);
	attributes.add(attrExecution);
    }

    // 把对象生成XML
    public void toXML(Node parent) throws DOMException {

	try {
	    if (helperElement.getChoices() != null && helperElement.getChoosen() != null && helperElement.getChoosen() instanceof XMLCollectionElement) {

		attrId.setValue(((XMLCollectionElement) helperElement.getChoosen()).getID());
	    }
	} catch (Exception ex) {
	    ex.printStackTrace();
	}

	if (attrId.toValue() == null || attrId.toValue().equals("")) {
	    attrId.setValue(UUID.randomUUID().toString());
	}

	if (isEmpty() && !isRequired())
	    return;
	if (parent != null) {
	    Node node = (parent.getOwnerDocument()).createElement("Block");
	    for (Iterator it = complexStructure.iterator(); it.hasNext();) {
		XMLElement el = (XMLElement) it.next();
		el.toXML(node);
	    }
	    parent.appendChild(node);
	}
    }

    /**
     * Called after importing of XML file to set the proper WorkflowProcess object for subflow reference, and proper
     * DataField objects for ActualParameters references, according on it's IDs read from XML.
     */
    protected void afterImporting() {
	// setting choosen workflow process
	String wantedWpID = attrId.toValue().toString();

    }

    /**
     * Uses a trick to set the cloned instance of actual parameters to be edited, so that canceling of changes to the
     * actual parameter collection can be handled - the real instance of actual parameters is set to the cloned instance
     * within the isValidData method.
     */
    public XMLPanel getPanel() {
	XMLPanel p = new XMLGroupPanel(this, new XMLElement[] { helperElement, attrExecution }, toLabel());
	return p;
    }

    // 解析XPDL文件保存到外流程活动对象
    public void fromXML(Node node) {
	Node destNode = node;
	if (node.getNodeName().equals("Implementation")) {
	    destNode = XMLUtility.getFirstChild(node, Node.ELEMENT_NODE);
	}
	super.fromXML(destNode);
    }
}
