/* Application.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import javax.swing.JTextField;

import org.w3c.dom.Node;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLComplexChoice;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.elements.formula.FormalParameters;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTextPanel;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class Application extends XMLCollectionElement {
	private Description refDescription = new Description(); // min=0

	// can be FormalParameters or ExternalReference
	// if fp->must be defined,if er->min=0
	private XMLComplexChoice refChoice;

	private ExtendedAttributes refExtendedAttributes = new ExtendedAttributes(
			this); // min=0

	private XMLAttribute attrName = new XMLAttribute("Name");

	/**
	 * Usefull to determine if this application is external to some collection
	 * or not.
	 */
	private transient Package myPackage = null;

	/** Enables canceling of changes to the extended attributes collection. */
	private ExtendedAttributes clonedEAs;

	/**
	 * Creates a new instance of the class.
	 * 
	 * @param aps
	 *            The reference to collection of applications where this
	 *            instance will be put into.
	 * @param p
	 *            The package where applications are defined.
	 */
	public Application(Applications aps, Package p) {
		super(aps);

		myPackage = p;

		refChoice = new XMLComplexChoice("Choice", new XMLElement[] {
				new FormalParameters(this, p), new ExternalReference() }, 0,
				true) {

			public void setValue(Object v) {
				super.setValue(v);
				if (v == choices[1]) {
					((FormalParameters) choices[0]).clear();
				} else if (v == choices[0]) {
					ExternalReference er = (ExternalReference) choices[1];
					er.set("xref", "");
					er.set("location", "");
					er.set("namespace", "");
				}
			}
		};

		// setting the prefix for generation of formal parameters
		String idPref = getID() + XMLCollectionElement.ID_DELIMITER + "For";
		FormalParameters fps = (FormalParameters) refChoice.getChoices()[0];
		fps.setIDPrefix(idPref);

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		super.fillStructure();
		// attrName.setRequired(true);
		complexStructure.add(attrName);
		attributes.add(attrName);
		complexStructure.add(refDescription);
		complexStructure.add(refChoice);
		complexStructure.add(refExtendedAttributes);
	}

	public XMLPanel getPanel() {
		clonedEAs = (ExtendedAttributes) refExtendedAttributes.clone();
		return new XMLGroupPanel(this, new XMLElement[] { attrId, attrName,
				refDescription, refChoice, clonedEAs }, toLabel());
	}

	/**
	 * Overrides super-class method to retreive the value of this class "Name"
	 * attribute. This is used when displaying instance of this class within
	 * dialog.
	 * 
	 * @return The "Name" attribute value of this class.
	 */
	public String toString() {
		String disp = attrName.toString();
		if (disp.trim().length() == 0) {
			disp = attrId.toString();
		}
		return disp;
	}

	/**
	 * Used to determine if application is external to some collection.
	 * 
	 * @return Package of application.
	 */
	public Package getPackage() {
		return myPackage;
	}

	public void fromXML(Node node) {
		processAttributes(node);

		// setting the prefix for generation of formal parameters
		String idPref = getID() + XMLCollectionElement.ID_DELIMITER + "For";
		FormalParameters fps = (FormalParameters) refChoice.getChoices()[0];
		fps.setIDPrefix(idPref);

		processElements(node);

		((Applications) myCollection).updateID(getID());
	}

	/**
	 * Checks if an ID entered by the user is unique.
	 */
	public boolean isIDUniqueAndValid(XMLPanel groupPanel) {
		XMLTextPanel tp = (XMLTextPanel) ((XMLGroupPanel) groupPanel)
				.getPanel(0);
		String IDToCheck = tp.getText();
		// if there is an element with given ID, return false
		XMLComplexElement app = getCollection().getCollectionElement(IDToCheck);
		boolean isOK = true;
		String message = null;
		String dialogTitle = null;
		if (app != null && app != this) {
			message = XMLUtil.getLanguageDependentString("ErrorIDMustBeUnique");
			dialogTitle = XMLUtil.getLanguageDependentString("DialogIDIsNotUnique");
			isOK = false;
		} else if (!XMLCollection.isIdValid(IDToCheck)) {
			message = XMLUtil.getLanguageDependentString("ErrorIDMustBeValid");
			dialogTitle = XMLUtil.getLanguageDependentString("DialogIDIsNotValid");
			isOK = false;
		}
		if (!isOK) {
			XMLPanel.errorMessage(groupPanel.getDialog(), dialogTitle, "",
					message);
			((JTextField) tp.getComponent(2)).requestFocus();
		}
		return isOK;
	}

	/**
	 * This method is called only if user doesn't press Cancel button within the
	 * dialog for editing Application properties, so the changes to the real
	 * collection of Applications are applied here.
	 * 
	 * @param groupPanel
	 *            The panel for editing parameters.
	 * @return always returns <tt>true</tt>.
	 */
	public boolean isValidEnter(XMLPanel groupPanel) {
		if (clonedEAs != null) {
			complexStructure.remove(refExtendedAttributes);
			refExtendedAttributes = clonedEAs;
			complexStructure.add(4, refExtendedAttributes);
		}
		return true;
	}

}
