/* No.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.activity;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLComplexElement;

/**
 * Represents a WfMC DTD element that has the similar name. 手动活动类型类
 * 
 * @see XML
 */
public class No extends XMLComplexElement {

	public No(Activity act) {
		super();
		setLabelName(ResourceManager
				.getLanguageDependentString("Activity.General.Type.No.value"));
	}

	/**
	 * Overrides super-class method to indicate that this element is never
	 * empty, so it's tag will always be written into XML file.
	 * 
	 * @return <tt>false</tt>
	 */
	public boolean isEmpty() {
		return false;
	}
}
