/* Activity.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：XML元素的活动类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.activity;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.config.AppConfigManager;
import com.ds.bpm.bpd.enums.ActivityDefTypeEnums;
import com.ds.bpm.bpd.graph.Subflow;
import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.plugin.PluginManager;
import com.ds.bpm.bpd.xml.*;
import com.ds.bpm.bpd.xml.elements.*;
import com.ds.bpm.bpd.xml.elements.event.ActivityEventBase;
import com.ds.bpm.bpd.xml.elements.event.ActivityEventEvent;
import com.ds.bpm.bpd.xml.elements.event.ActivityEventNo;
import com.ds.bpm.bpd.xml.panels.*;
import com.ds.bpm.enums.route.RouteCondition;
import com.ds.common.util.XMLUtility;
import com.ds.config.BPDProjectConfig;
import com.ds.config.CParameter;
import com.ds.config.PluginType;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

import javax.swing.*;
import java.util.*;

/**
 * Represents a WfMC DTD element that has the similar name. An object of this
 * class is attribute of class com.ds.bpm.bpd.graph.Activity, which is visual
 * representation of this class. 活动元素类
 */
public class Activity extends XMLCollectionElement {

    /**
     * Container for activities.
     */
    private transient WorkflowProcess myWorkflow = null;

    // 内部资源属性
    private transient Map properties = new HashMap();

    // ---------活动基本属性----------
    // 活动名称
    private XMLAttribute attrName = new XMLAttribute("Name");

    // 活动描述
    private Description refDescription = new Description(); // min=0

    // 监听器
    private Listeners listeners = new Listeners(this);

    // ---------活动高级属性----------
    private ActivityEventBase activityEvent;

    // private DeviceEvent deviceEvent;

    // 插件工具类
    private transient PluginManager manager;

    // 活动插件属性集
    private transient Map plugins;

    // 流程原插件属性集
    private transient Map oldPlugins = new HashMap();

    // 活动Panel集合
    private transient List panels;

    // can be AutoActivity or Implementation
    private XMLComplexChoice refType; // must be defined

    private Performer refPerformer = new Performer(); // min=0

    private TransitionRestrictions refTransitionRestrictions = new TransitionRestrictions(this);

    // min=0
    private ExtendedAttributes refExtendedAttributes = new ExtendedAttributes(this);

    // min=0

    /**
     * Used for holding references and defining of user defined properties for
     * activity.
     */
    private UserPropertyRefs helperUserPRefs;

    /**
     * Enables canceling of changes to the user property collection.
     */
    private UserPropertyRefs clonedUPRs;

    /**
     * Enables canceling of changes to the tool collection.
     */
    private Tools clonedTools;

    /**
     * Enables canceling of changes to the extended attributes collection.
     */
    private ExtendedAttributes clonedEAs;

    /**
     * Enables canceling of changes to the TransitionRefs collection.
     */
    private XMLCollection clonedHP;

    /**
     * Used to save to XML file so called pre- and post-conditions as well as
     * InlineBlock restriction.
     */
    //private transient TransitionRestriction helperTR;
    //
//    /**
//     * Used to show so called preconditions
//     */
    private transient Join helperJoin;

    /**
     * Used to show so called postconditions
     */
    private transient Split helperSplit;

    /**
     * Used to show so called postconditions
     */
    private transient TransitionRefs helperTRefs;

    /**
     * Used to show so called postconditions
     */
    // private transient XMLComplexChoice helperPostcondition;
    private transient XMLCollection helperPostcondition;

    /**
     * This is introduced because of visual inserting of various types
     */
    private transient XMLElement helperElement;

    /**
     * Used to hold the visual order of participants within workflow process graph.
     * Set and valid only immediatelly after exporting to or immediatelly after
     * importing from an XML file. This is used only for Block activities.
     */
    private transient String visuallySortedParticipantIDs = "";

    /*
     * The set of strings where extended attribute information for description of
     * visual properties for starts of block activity are held. This information is
     * valid only immediatelly after exporting to or immediatelly after importing
     * from an XML file. This is used only for Block activities.
     */
    private Set startDescriptions = new HashSet();

    /*
     * The set of strings where extended attribute information for description of
     * visual properties for ends of block activity are held. This information is
     * valid only immediatelly after exporting to or immediatelly after importing
     * from an XML file. This is used only for Block activities.
     */
    private Set endDescriptions = new HashSet();

    /**
     * X-offset of graph object in respect to origin of Participant graph object
     * that holds it.
     */
    private transient int XOffset = -1;

    /**
     * Y-offset of graph object in respect to origin of Participant graph object
     * that holds it.
     */
    private transient int YOffset = -1;

    /**
     * An ID of Participant's graph object that visualy holds graph object of
     * activity.
     */
    private transient String participantID = "";

    /**
     * List of transitions which source is the activity.
     */
    private transient Set outgoingTransitions = new HashSet();

    // type: 0 - route, 1-no, 2-tool, 3-subflow, 4-block

    /**
     * Constructs an Activity object that will be contained within a given workflow
     * process, and of specified type.
     * <p>
     * These are valid types:
     * <ul>
     * <li>0 - route activity type
     * <li>1 - no activity type (activity that doesn't have implementation)
     * <li>2 - tool activity type (activity that implements some applications)
     * <li>3 - subflow activity type
     * <li>4 - block activity type
     * </ul>
     *
     * @param acts       The reference to collection of activities where this
     *                   instance will be put into.
     * @param myWorkflow The workflow process that contains activity.
     * @param type       The type of activity.
     */
    public Activity(Activities acts, WorkflowProcess myWorkflow, ActivityDefTypeEnums type) {
        super(acts);
        this.myWorkflow = myWorkflow;
        if (myWorkflow != null) {
            helperUserPRefs = new UserPropertyRefs(myWorkflow.getPackage());
        }

        setType(type);

        if (type == null || type.equals(ActivityDefTypeEnums.No)) {
            activityEvent = new ActivityEventNo(myWorkflow, this);
        } else {
            activityEvent = new ActivityEventEvent(myWorkflow, this);
        }
        setDefaultTransitionRestriction(null);
        //   refTransitionRestrictions.add(helperTR);
        loadPlugins();
        fillStructure();
        fillPlugins();
        recreatePostcondition();
        afterImporting(false);
        // 初始化页面显示信息
        // 活动通用属性
        attrId.setReadOnly(true);
        attrId.setLabelName(ResourceManager.getLanguageDependentString("Activity.General.ID.display"));
        attrName.setLabelName(ResourceManager.getLanguageDependentString("Activity.General.Name.display"));
        refDescription.setLabelName(ResourceManager.getLanguageDependentString("Activity.General.Description.display"));
    }

    private void setDefaultTransitionRestriction(TransitionRestriction tr) {
//        if (tr != null) {
//            helperTR = tr;
//        } else {
//            helperTR = new TransitionRestriction();
//        }
        helperJoin = (Join) this.getActivityEvent().getJoin();
        helperSplit = (Split) this.getActivityEvent().getSplit();
        helperTRefs = (TransitionRefs) helperSplit.getRefTransitionRefs();
    }

    /**
     * Returns a workflow process that contains activity.
     *
     * @return The workflow process that ownes activity.
     */
    public WorkflowProcess getOwnerProcess() {
        return myWorkflow;
    }

    /**
     * Returns a workflow process that contains activity.
     *
     * @return The workflow process that ownes activity.
     */
    public ActivityEventBase getActivityEvent() {
        return this.activityEvent;
    }

    public void setActivityEvent(ActivityEventBase activityEvent) {
        this.activityEvent = activityEvent;
    }

    // *****************************************************************
    // 解析XPDL文件保存到活动对象
    public void fromXML(Node node) {
        refTransitionRestrictions.clear();
        super.fromXML(node);
        // 解析XPDL文件设置活动节点类型
        Node implNode = XMLUtility.getFirstChild(node, "Implementation");
        Node typeNode = XMLUtility.getFirstChild(implNode, Node.ELEMENT_NODE);
        String typeName = typeNode.getNodeName();

        refTransitionRestrictions.fromXML(node);


        ActivityDefTypeEnums type = ActivityDefTypeEnums.fromName(typeName);

        // activityEvent.fromXML(node);


        if (type == null || type.equals(ActivityDefTypeEnums.No)) {
            activityEvent = new ActivityEventNo(myWorkflow, this);
        } else {
            activityEvent = new ActivityEventEvent(myWorkflow, this);
        }

        this.activityEvent.fromXML(node);
        complexStructure.add(activityEvent);
        for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry entry = (Map.Entry) it.next();
            complexStructure.add(entry.getValue());
        }

        setType(type);

        helperElement.fromXML(implNode);
    }

    protected void afterImporting() {
        afterImporting(true);
    }

    /**
     * Called by Package object after importing of XML file to set the proper
     * Participant objects for performer of activity, according on it's ID read from
     * XML, to set proper reference to workflow process for activities of Subflow
     * type, and to set proper user defined activity properties.
     */
    protected void afterImporting(boolean importUserProperties) {
        // adjusting TransitionRestrictions
        Object newTR = refTransitionRestrictions.get(0);

        setDefaultTransitionRestriction((TransitionRestriction) newTR);
        // check if there is more than one transition restriction within
        // collection,
        // and if it is, add all found transition references, or split, join
        // objects if they doesn't exist already
        // NOTE: this is because other vendors might implemented more that one
        // transition restriction

        int size = refTransitionRestrictions.size();
        if (size > 1) {
            for (int i = 1; i < size; i++) {
                TransitionRestriction tr = (TransitionRestriction) refTransitionRestrictions.get(i);
                Split s = (Split) tr.get("Split");
                TransitionRefs trfs = (TransitionRefs) s.getRefTransitionRefs();
                if (trfs.size() > 0 && helperSplit.get("Type").toValue().toString().length() == 0) {
                    helperSplit.set("Type", s.get("Type").toString());
                }
                helperTRefs.toCollection().addAll(trfs.toCollection());
            }
        }
        // System.out.println("Act "+this+", trefs="+helperTRefs.size());

        // clear collection, and add helperTR to collection again
        refTransitionRestrictions.clear();
        //    refTransitionRestrictions.add(helperTR);

        // adjusting extended attrib. (if this is made by PE)
        // remove all internally used ext. attribs
        Set easToRemove = new HashSet();
        if (myWorkflow.getPackage().isMadeByBPD()) {
            Iterator it = refExtendedAttributes.toCollection().iterator();
            String nm = "";
            String val = "";
            while (it.hasNext()) {
                ExtendedAttribute ea = (ExtendedAttribute) it.next();
                nm = ea.get("Name").toValue().toString();
                val = ea.get("Value").toValue().toString();
                if (nm.equalsIgnoreCase("XOffset") && XOffset == -1) {
                    try {
                        XOffset = Integer.parseInt(val);
                    } catch (Exception ex) {
                        XOffset = 0;
                    }
                    easToRemove.add(ea);
                }
                if (nm.equalsIgnoreCase("YOffset") && YOffset == -1) {
                    try {
                        YOffset = Integer.parseInt(val);
                    } catch (Exception ex) {
                        YOffset = 0;
                    }
                    easToRemove.add(ea);
                }
                if (nm.equalsIgnoreCase("ParticipantID") && participantID.length() == 0) {
                    participantID = val;
                    easToRemove.add(ea);
                }
                if (importUserProperties && nm.startsWith("ActivitiesUserProperty")) {
                    UserProperties ups = myWorkflow.getPackage().getUserDefinedActivityProperties();
                    String ID = nm.substring("ActivitiesUserProperty".length(), nm.length());
                    if (ID == null)
                        continue;
                    // temporarily put it to the value, and after whole XML file
                    // is imported, the method adjustUserProperties will be
                    // called to set the proper user property
                    UserPropertyRef upr = new UserPropertyRef();
                    UserProperty up = ups.getProperty(ID);
                    if (up == null)
                        continue;
                    upr.setValue(up);
                    upr.set("Value", val);
                    helperUserPRefs.add(upr);
                    // add this ea to the collection for removal
                    easToRemove.add(ea);
                }
                if (nm.equalsIgnoreCase("ParticipantVisualOrder") && visuallySortedParticipantIDs.length() == 0) {
                    visuallySortedParticipantIDs = val;
                    easToRemove.add(ea);
                }
                if (nm.equalsIgnoreCase("StartOfBlock")) {
                    if (XMLUtil.howManyStringsWithinString(val, ";") == 4) {
                        startDescriptions.add(val);
                        easToRemove.add(ea);
                    }
                }
                if (nm.equalsIgnoreCase("EndOfBlock")) {
                    if (XMLUtil.howManyStringsWithinString(val, ";") == 4) {
                        endDescriptions.add(val);
                        easToRemove.add(ea);
                    }
                }
            }
        }
        // removing internally used ext. attribs - otherwise, it would
        // be shown within ea list
        refExtendedAttributes.toCollection().removeAll(easToRemove);

        // adjusting participants
        Participants ps = (Participants) myWorkflow.get("Participants");
        Participant perf = ps.getParticipant(refPerformer.toValue().toString());
        if (perf != null) {
            refPerformer.setValue(perf);
        }
        ActivityDefTypeEnums type = getType();
        activityEvent.afterImporting();

        listeners.afterImporting();

        try {
            loadPlugins();
            fillPlugins();
            for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
                Map.Entry entry = (Map.Entry) it.next();
                ((PluginElement) entry.getValue()).afterImporting();
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        // adjusting workflow process reference and actual parameters
        if (type.equals(ActivityDefTypeEnums.SubFlow)) {
            getSubflow().afterImporting();
        }
        // 监听器设置

        // postconditions must be created here, otherwise, the order
        // of trefs want be correct
        helperPostcondition = null;
        recreatePostcondition();

    }

    /*
     * Returns extended attribute information for description of visual properties
     * for all starts of block activity. Valid only after importing from an
     * XML. @return The specific set of descriptions of Start objects attributes.
     */
    public Set getStartDescriptions() {
        return startDescriptions;
    }

    /*
     * Sets extended attribute information for description of visual properties for
     * all starts of block. @param sd The specific set of descriptions of Start
     * objects attributes.
     */
    public void setStartDescriptions(Set sd) {
        startDescriptions = sd;
    }

    /*
     * Returns extended attribute information for description of visual properties
     * for all ends of block. Valid only after importing from an XML.
     *
     * @return The specific set of descriptions of End objects attributes.
     */
    public Set getEndDescriptions() {
        return endDescriptions;
    }

    /*
     * Sets extended attribute information for description of visual properties for
     * all ends of block. @param eds The specific set of descriptions of End objects
     * attributes.
     */
    public void setEndDescriptions(Set eds) {
        endDescriptions = eds;
    }

    /**
     * Used to get the visual order of participant visual objects contained within a
     * BlockActivity graph.
     * <p>
     * NOTE: This order is valid only immediately after import of WorkflowProcess or
     * it's export to XML file, also, this order is an ExtendedAttribute in a WfMC
     * DTD sence, so it is valid only for XMLs saved by this version of the BPD
     * application.
     *
     * @return String representation of visually sorted participant ID's.
     */
    public String getVisuallySortedParticipantIDs() {
        return visuallySortedParticipantIDs;
    }

    /**
     * Used to set the visual order of participant visual objects contained within a
     * BlockActivity graph.
     *
     * @param vsPID String representation of visually sorted participant ID's.
     */
    public void setVisuallySortedParticipantIDs(String vsPID) {
        visuallySortedParticipantIDs = vsPID;
    }

    /**
     * Called to get the visual position of Activity.
     *
     * @return X-offset in respect to origin of Participant's graph object that
     * visually holds activity.
     */
    public int getXOffset() {
        return XOffset;
    }

    /**
     * Called to set the visual position of Activity.
     *
     * @param xOffs X-offset in respect to origin of Participant's graph object that
     *              visually holds activity.
     */
    public void setXOffset(int xOffs) {
        XOffset = xOffs;
    }

    /**
     * Called to get the visual position of Activity.
     *
     * @return Y-offset in respect to origin of Participant's graph object that
     * visually holds activity.
     */
    public int getYOffset() {
        return YOffset;
    }

    /**
     * Called to set the visual position of Activity.
     *
     * @param yOffs Y-offset in respect to origin of Participant's graph object that
     *              visually holds activity.
     */
    public void setYOffset(int yOffs) {
        YOffset = yOffs;
    }

    /**
     * @return String representation of ID of participant that visualy contains
     * activity.
     */
    public String getParticipantID() {
        return participantID;
    }

    /**
     * @param pID String representation of ID of participant that visualy contains
     *            activity.
     */
    public void setParticipantID(String pID) {
        participantID = pID;
    }

    public void setOutgoingTransitions(Set ts) {
        outgoingTransitions = ts;
    }

    // *****************************************************************

    /**
     * Returns an activity type.
     * <p>
     * These are possible types:
     * <ul>
     * <li>0 - route activity type
     * <li>1 - no activity type (activity that doesn't have implementation)
     * <li>2 - tool activity type (activity that implements some applications)
     * <li>3 - subflow activity type
     * <li>4 - block activity type
     * </ul>
     *
     * @return The integer value that represents the type of activity.
     */
    public ActivityDefTypeEnums getType() {
        return getType(helperElement);
    }

    /**
     * Sets the Join restriction type of activity. This is called by WorkflowProcess
     * after importing of an XML but only if activity is the first activity of block
     * activity.
     *
     * @param type The type of Join, which can be AND or XOR.
     */
    public void setJoinType(String type) {
        helperJoin.set("Type", type);
    }

    /**
     * Used to retrieve Join element.
     *
     * @return Join element.
     */
    public Join getJoin() {
        return helperJoin;
    }

    /**
     * Sets the Split restriction type of activity. This is called by
     * WorkflowProcess after importing of an XML but only if activity is the last
     * activity of block activity.
     *
     * @param type The type of Split, which can be AND or XOR.
     */
    public void setSplitType(String type) {
        helperSplit.set("Type", type);
    }

    /**
     * Used to retrieve Split element.
     *
     * @return Split element.
     */
    public Split getSplit() {
        return helperSplit;
    }

    public Tools getTools() {
        if (getType().equals(ActivityDefTypeEnums.Tool)) {
            return (Tools) helperElement;
        }
        return null;
    }

    public SubFlow getSubflow() {
        if (getType().equals(ActivityDefTypeEnums.SubFlow)) {
            return (SubFlow) helperElement;
        }
        return null;
    }

    public OutFlow getOutflow() {
        if (getType().equals(ActivityDefTypeEnums.OutFlow)) {
            return (OutFlow) helperElement;
        }
        return null;
    }

    public Services getServices() {
        if (getType().equals(ActivityDefTypeEnums.Service)) {
            return (Services) helperElement;
        }
        return null;
    }

    public Devices getDevices() {
        if (getType().equals(ActivityDefTypeEnums.Device)) {
            return (Devices) helperElement;
        }
        return null;
    }

    public Events getEvents() {
        if (getType().equals(ActivityDefTypeEnums.Event)) {
            return (Events) helperElement;
        }
        return null;
    }

    public BlockActivity getBlockActivity() {
        if (getType().equals(ActivityDefTypeEnums.Block)) {
            return (BlockActivity) helperElement;
        }
        return null;
    }

    /**
     * Returns the integer value that represents the type of activity. 得到活动类型
     */
    private ActivityDefTypeEnums getType(XMLElement helper) {
        return ActivityDefTypeEnums.fromClass(helper.getClass());
    }

    // type: 0 - route, 1-no, 2-tool, 3-subflow, 4-block activity,5-outflow
    // 6,servite
    // 0-自动活动,2-手动活动,3-子流程,4-外流程,5-外部流程引用 6,服务节点 7,设备流程 8,事件

    /**
     * Sets the type of activity.
     */
    private void setType(ActivityDefTypeEnums type) {

        Implementation i = new Implementation(this);
        AutoActivity r = new AutoActivity();

        BlockActivity ba = new BlockActivity(this);
        Services s = new Services(this);

        refType = new XMLComplexChoice("Type", new XMLElement[]{r, i, ba, s}, 1, false, false, false, true, true);
        XMLComplexChoice t = (XMLComplexChoice) i.get("Type");
        int index = 0;
        switch (type.getType()) {
            case 0:

            case 1:
                index = 0;
                break;
            default:
                index = type.getType() - 1;
                break;
        }
        helperElement = (XMLElement) t.getChoices()[index];
        t.setValue(helperElement);
        refType.setValue(i);
    }

    /**
     * Defines the super-class method. Read the explanation for this method within
     * XMLComplexElement class.
     */
    protected void fillStructure() {
        super.fillStructure();
        complexStructure.add(attrName);
        attributes.add(attrName);
        complexStructure.add(refDescription);
        refType.setRequired(true);
        complexStructure.add(refType);
        refPerformer.setReadOnly(true);
        complexStructure.add(refPerformer);
        complexStructure.add(refExtendedAttributes);
        this.getJoin();
        complexStructure.add(activityEvent);

        ExtendedAttribute ea;
        // 把监听器属性加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.get("Value").setRequired(false);
        ea.set("Name", listeners.toName());
        ea.setAnyXMLCollection(listeners);
        ((ArrayList) refExtendedAttributes.toCollection()).add(ea);

        // 把活动位置属性加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.set("Name", "Position");
        ea.set("Value", "NORMAL");
        ((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
    }

    private void fillPlugins() {
        // if (getType() == 2) {
        for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry entry = (Map.Entry) it.next();
            String name = (String) entry.getKey();
            Object val = entry.getValue();
            if (oldPlugins.containsKey(name)) {
                Object oldVal = oldPlugins.get(name);
                int index = complexStructure.indexOf(oldVal);
                // complexStructure.set(index, val);
                plugins.put(name, oldVal);
            } else {
                complexStructure.add(val);
            }
            oldPlugins.put(name, val);
        }
        // }
    }

    /**
     * Prepares the tabbed panel to show editable fields of Activity. Panel consists
     * of six tabs that logically comprises the Activity elements to be edited.
     * 活动展示Panel
     *
     * @return XMLPanel to be shown.
     */
    public XMLPanel getPanel() {
        // just to display type of activity
        XMLAttribute tp = new XMLAttribute("Type");
        tp.setLabelName(ResourceManager.getLanguageDependentString("Activity.General.Type.display"));
        tp.setValue(helperElement.toLabel());
        tp.setReadOnly(true);

        ActivityDefTypeEnums type = getType();

        XMLPanel basePanel = new XMLGroupPanel(this,
                new XMLElement[]{attrId, attrName, tp, refDescription, listeners},
                ResourceManager.getLanguageDependentString("Activity.General.display"));

        XMLPanel simplePanel = helperElement.getPanel();

        XMLPanel advPanel = activityEvent.getPanel();

        panels = new ArrayList();

        panels.add(basePanel);

        //	panels.add(advPanel);
        //	loadPlugins();
//
        switch (type) {
            case No:
                panels.add(advPanel);
                break;
            case Tool:
                panels.add(advPanel);
                break;
            case Block:
                panels.add(advPanel);
                break;
            case Service:
                panels.add(advPanel);
                break;
            case Event:
                panels.add(advPanel);
                break;
            case SubFlow:
                panels.add(advPanel);
                SubFlow subFlow = new SubFlow(this);
                panels.add(subFlow.getPanel());
                break;
            case OutFlow:
                panels.add(advPanel);
                break;
            case Device:
                panels.add(advPanel);
                break;

            default:
                break;
        }

        for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry entry = (Map.Entry) it.next();
            PluginElement pluginElement = (PluginElement) entry.getValue();
            panels.add(pluginElement.getPanel());
        }

        XMLTabbedPanel p = new XMLTabbedPanel(this, (XMLPanel[]) panels.toArray(new XMLPanel[]{}));
        return p;
    }

    protected void fillOutgoingTransitions() {
        Transitions ts = (Transitions) getCollection().getOwner().get("Transitions");
        Set ots = ts.getTransitions(getID(), -1);
        if (ots != null) {
            outgoingTransitions.clear();
            outgoingTransitions.addAll(ots);
        }
        this.activityEvent.checkJoin();

    }

    /**
     * Used to get all outgoing transitions of Activity so it could be put in the
     * list so user can choose the transition to wanted activity and modify it, and
     * he can change the transition position within the list which causes the change
     * of TransitionRefs order.
     */
    private void recreatePostcondition() {
        if (helperPostcondition == null) {
            helperPostcondition = createPostcondition();
            Transitions ts = (Transitions) getCollection().getOwner().get("Transitions");
            Iterator it = helperTRefs.toCollection().iterator();
            while (it.hasNext()) {
                TransitionRef tr = (TransitionRef) it.next();
                String tId = tr.toValue().toString();
                Transition t = ts.getTransition(tId);
                helperPostcondition.add(t);
            }
        } else {
            Set otCopy = new HashSet(outgoingTransitions);
            Set toRem = new HashSet();
            Iterator it = helperPostcondition.toCollection().iterator();
            while (it.hasNext()) {
                Object t = it.next();
                if (!otCopy.remove(t)) {
                    toRem.add(t);
                }
            }
            helperPostcondition.toCollection().removeAll(toRem);
            // add the rest of outgoing transitions (there may be transitions in
            // the copy set if we didn't entered property dialog after adding
            // transition or we newer entered it)
            it = otCopy.iterator();
            while (it.hasNext()) {
                Transition t = (Transition) it.next();
                if (t.getTo() != null) {
                    helperPostcondition.add(t);
                }
            }
        }
    }

    /**
     * Adds an user defined property to the activity. This is used when the new
     * Activity is created by inserting it's visual object into the graph, to set
     * all mandatory user properties defined, or when the new mandatory property is
     * created.
     *
     * @param up The mandatory user property to add.
     */
    public void addUserProperty(UserProperty up) {
        helperUserPRefs.addUserProperty(up);
    }

    /**
     * Removes an user defined property upon it's removal from collection of
     * properties.
     *
     * @param up The user property to remove.
     */
    public void removeUserProperty(UserProperty up) {
        helperUserPRefs.removeUserProperty(up);
    }

    /**
     * Adds an user defined property after the user changed it's type from
     * <tt>OPTIONAL</tt> to <tt>MANDATORY</tt>.
     *
     * @param up The mandatory user property to add.
     */
    public void refreshMandatories(UserProperty up) {
        helperUserPRefs.refreshMandatories(up);
    }

    /**
     * Overrides <code>toString</code> method to return the name of Activity. This
     * string is used to visually display the activity name onto it's graph object.
     *
     * @return The activity <tt>name</tt> attribute.
     */
    public String toString() {
        String disp = attrName.toString();
        if (disp.trim().length() == 0) {
            disp = attrId.toString();
        }
        return disp;
    }

    /**
     * Gets the tooltip for activity. The tooltip consists of property names and
     * values.
     *
     * @return The tooltip to be displayed when user holds the mouse above
     * activity's graph object.
     */
    public String getTooltip() {
        XMLElement tp = new XMLElement("Type");
        tp.setValue(helperElement.toLabel());
        return XMLUtil.makeTooltip(new XMLElement[]{attrName, tp, refDescription});
    }

    /**
     * Overrides super-class method to realize this class specific writting to XML
     * file.
     */
    public void toXML(Node parent) throws DOMException {
        // prepearing transition refs for xml saving
        // must consider the order written within helperPostcondition
        helperTRefs.clear();
        Set otCopy = new HashSet(outgoingTransitions);
        if (helperPostcondition != null) {
            Iterator it = helperPostcondition.toCollection().iterator();
            while (it.hasNext()) {
                Transition t = (Transition) it.next();
                if (otCopy.remove(t)) {
                    if (t.getTo() != null) {
                        String ID = t.getID();
                        TransitionRef tr = new TransitionRef();
                        tr.setValue(ID);
                        helperTRefs.add(tr);
                    }
                }
            }
        }
        // add the rest of outgoing transitions (there may be transitions in
        // the copy set if we didn't entered property dialog after adding
        // transition or we newer entered it)
        Iterator it = otCopy.iterator();
        while (it.hasNext()) {
            Transition t = (Transition) it.next();
            if (t.getTo() != null) {
                String ID = t.getID();
                TransitionRef tr = new TransitionRef();
                tr.setValue(ID);
                helperTRefs.add(tr);
            }
        }

        // *************** prepearing extended attributes
        // remove all internally used ext. attribs
        Set easToRemove = new HashSet();

        ExtendedAttribute ea;

        // user defined attributes
        ArrayList huprl = (ArrayList) helperUserPRefs.toCollection();
        ListIterator lit = huprl.listIterator(huprl.size());
        while (lit.hasPrevious()) {
            UserPropertyRef upr = (UserPropertyRef) lit.previous();
            ea = new ExtendedAttribute(refExtendedAttributes);
            UserProperty up = (UserProperty) upr.toValue();
            String ID = up.getID();
            ea = new ExtendedAttribute(refExtendedAttributes);
            ((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
            ea.set("Name", "ActivitiesUserProperty" + ID);
            ea.set("Value", upr.get("Value").toValue().toString());
            easToRemove.add(ea);
        }

        // position
        ea = new ExtendedAttribute(refExtendedAttributes);
        ((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
        ea.set("Name", "YOffset");
        ea.set("Value", String.valueOf(YOffset));
        easToRemove.add(ea);

        ea = new ExtendedAttribute(refExtendedAttributes);
        ((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
        ea.set("Name", "XOffset");
        ea.set("Value", String.valueOf(XOffset));
        easToRemove.add(ea);

        // participant (to adjust visualy when reading from file)
        ea = new ExtendedAttribute(refExtendedAttributes);
        ((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
        ea.set("Name", "ParticipantID");
        ea.set("Value", participantID);
        easToRemove.add(ea);

        // if this is a block activity, write some additional attributes
        if (getType().equals(ActivityDefTypeEnums.Block)) {
            // ********* writing participants visual order
            if (visuallySortedParticipantIDs.length() > 0) {
                ea = new ExtendedAttribute(refExtendedAttributes);
                ((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
                ea.set("Name", "ParticipantVisualOrder");
                ea.set("Value", visuallySortedParticipantIDs);
                easToRemove.add(ea);
            }
            // ******* writting end descriptions
            if (endDescriptions.size() > 0) {
                it = endDescriptions.iterator();
                while (it.hasNext()) {
                    ea = new ExtendedAttribute(refExtendedAttributes);
                    ((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
                    ea.set("Name", "EndOfBlock");
                    ea.set("Value", (String) it.next());
                    easToRemove.add(ea);
                }
            }
            // ************** writting start description
            if (startDescriptions.size() > 0) {
                it = startDescriptions.iterator();
                while (it.hasNext()) {
                    ea = new ExtendedAttribute(refExtendedAttributes);
                    ((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
                    ea.set("Name", "StartOfBlock");
                    ea.set("Value", (String) it.next());
                    easToRemove.add(ea);
                }
            }
        }

        // if implementation is tool and there is no defined tools switch
        // implementation to no implementation until xml is written
        if (helperElement instanceof Tools && ((Tools) helperElement).size() == 0) {
            // setting type of activity to no implementation
            Implementation i = (Implementation) refType.getChoices()[1];
            XMLComplexChoice t = (XMLComplexChoice) i.get("Type");
            XMLElement tmp = (XMLElement) t.getChoices()[0];
            t.setValue(tmp);
            super.toXML(parent);
            // setting back
            t.setValue(helperElement);
        } else {
            complexStructure.remove(3);
            complexStructure.add(3, refType);
            super.toXML(parent);
        }
        // removing internally used ext. attribs - otherwise, it would be
        // duplicated
        // this.listeners.toXML(parent);
        refExtendedAttributes.toCollection().removeAll(easToRemove);

    }

    public void setReadOnly(boolean ro) {
        super.setReadOnly(ro);
        helperUserPRefs.setReadOnly(true);
    }

    /**
     * Used when copying activities of Application(Tools) and AutoActivity type. The
     * newly created activity will have all properties same as the copied one,
     * except that it will have diferent ID.
     *
     * @return The newly created Activity object.
     */
    public Object clone() {
        Activity a = (Activity) super.clone();
        a.attrId.setValue(myCollection.generateID());
        a.attrName = (XMLAttribute) this.attrName.clone();
        a.refDescription = (Description) this.refDescription.clone();
        a.refType = (XMLComplexChoice) this.refType.clone();
        a.refPerformer = (Performer) this.refPerformer.clone();
        a.refTransitionRestrictions = (TransitionRestrictions) this.refTransitionRestrictions.clone();
        a.refExtendedAttributes = (ExtendedAttributes) this.refExtendedAttributes.clone();

        ActivityDefTypeEnums type = getType(helperElement);
        a.setType(type);

        a.myWorkflow = this.myWorkflow;
        a.outgoingTransitions = new HashSet();
        // 监听器
        a.listeners = (Listeners) this.listeners.clone();

        // 删除clone的扩展属性
        a.refExtendedAttributes.clear();

        a.activityEvent = this.activityEvent.clone();

        a.helperUserPRefs = (UserPropertyRefs) this.helperUserPRefs.clone();
        // creating new transition restriction and filling helper elements
        a.refTransitionRestrictions.clear();
        a.setDefaultTransitionRestriction(null);
        //   a.refTransitionRestrictions.add(a.helperTR);
        a.helperJoin.set("Type", ((XMLAttribute) helperJoin.get("Type")).getChoosen().toString());
        a.helperSplit.set("Type", ((XMLAttribute) helperSplit.get("Type")).getChoosen().toString());
        // adapting helperElement
        a.helperPostcondition = a.createPostcondition();
        a.clonedUPRs = null;
        a.clonedTools = null;
        a.clonedEAs = null;
        a.clonedHP = null;
        a.fillStructure();

        // clone插件
        a = clonePlugins(a);
        // 保存clone的活动到BPD的actMap中，便于连接路由
        Map actMap = BPD.getInstance().getActMap();
        actMap.put(getID(), a);
        return a;
    }

    public void refreshLabelName() {
        super.refreshLabelName();
        helperUserPRefs.refreshLabelName();
    }

    /**
     * Checks if an ID entered by the user is unique.
     */
    public boolean isIDUniqueAndValid(XMLPanel tabbedPanel) {
        XMLGroupPanel groupPanel = (XMLGroupPanel) ((XMLTabbedPanel) tabbedPanel).getTabbedPanel(0);
        XMLTextPanel tp = (XMLTextPanel) groupPanel.getPanel(0);
        String IDToCheck = tp.getText();
        // if there is an element with given ID, return false
        XMLComplexElement act = getCollection().getCollectionElement(IDToCheck);
        boolean isOK = true;
        String message = null;
        String dialogTitle = null;
        if (act != null && act != this) {
            message = XMLUtil.getLanguageDependentString("ErrorIDMustBeUnique");
            dialogTitle = XMLUtil.getLanguageDependentString("DialogIDIsNotUnique");
            isOK = false;
        } else if (!XMLCollection.isIdValid(IDToCheck)) {
            message = XMLUtil.getLanguageDependentString("ErrorIDMustBeValid");
            dialogTitle = XMLUtil.getLanguageDependentString("DialogIDIsNotValid");
            isOK = false;
        }
        if (!isOK) {
            XMLPanel.errorMessage(groupPanel.getDialog(), dialogTitle, "", message);
            ((JTextField) tp.getComponent(2)).requestFocus();
        }

        return isOK;
    }

    /**
     * If activity type is SubFlow, checks if actual and formal params are matched
     * by type and number. This method is called only if user presses OK button
     * within the dialog for editing Activity properties, so the changes to the user
     * property collection as well as the changes in the tool collection (if
     * activity type is tool) are made only in that case.
     *
     * @param p The panel for editing parameters.
     * @return If this is an activity which type is not SubFlow, always returns
     * <tt>true</tt>, and f this is a SubFlow type activity, returns
     * <tt>true</tt> if actual and formal parameter types and number are
     * matching, <tt>false</tt> otherwise. 活动节点数据合法性判断
     */
    public boolean isValidEnter(XMLPanel p) {
        ActivityDefTypeEnums type = getType(helperElement);
        if (type.equals(ActivityDefTypeEnums.SubFlow)) {
            if (!getSubflow().isValidEnter(((XMLTabbedPanel) p).getTabbedPanel(1))) {
                return false;
            }
        }
        if (!type.equals(ActivityDefTypeEnums.Device) && !type.equals(ActivityDefTypeEnums.Event)) {
            try {
                if (!activityEvent.isValidEnter((XMLPanel) panels.get(1))) {
                    return false;
                }

                if (panels.size() > 2) {
                    int index = 2;

                    for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
                        Map.Entry entry = (Map.Entry) it.next();
                        boolean ret = ((PluginElement) entry.getValue()).isValidEnter((XMLPanel) panels.get(index));
                        if (ret) {
                            index++;
                        } else {
                            return false;
                        }
                    }
                }

            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        return true;

    }

    private XMLCollection createPostcondition() {
        XMLCollection pConds = new XMLCollection(this) {
            public XMLPanel getPanel() {
                return new XMLListChoicePanel(this, XMLUtil.getLanguageDependentString("SelectTargetActivityKey"),
                        XMLPanel.BOX_LAYOUT, true, false);
            }
        };
        pConds.setReadOnly(isReadOnly);
        return pConds;
    }

    /**
     * Used to set the collection that activity belongs to. The activity can change
     * its collection when it is beeing copied from the process to the block or
     * vice-versa.
     */
    protected void setCollection(Activities newCollection) {
        this.myCollection = newCollection;
    }

    public void setPosition(String position) {
        ExtendedAttributes exAttrs = (ExtendedAttributes) get("ExtendedAttributes");
        if (exAttrs != null && exAttrs.getExtendedAttribute("Position") != null) {
            exAttrs.getExtendedAttribute("Position").set("Value", position);
        }

    }

    private String getTypeKey() {
        return this.getType().getDef().getType();
    }

    private void loadPlugins() {
        // 读取活动插件
        try {
            // if (plugins != null
            // && manager.getAppName() == myWorkflow.getAppName()) {
            // return;
            // }
            manager = PluginManager.getInstance(myWorkflow.getAppName(), myWorkflow.getClassifications());

            plugins = manager.getPlugins(PluginType.Activity, this.getType().getDef());

            for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
                Map.Entry entry = (Map.Entry) it.next();
                PluginElement pe = (PluginElement) entry.getValue();

                pe.setType(PluginType.Activity);
                pe.setProperty("Activity", this);
                pe.setProperty("WorkflowProcess", getOwnerProcess());
                BPDProjectConfig classification = AppConfigManager.getInstance().getApplicationMap().get(myWorkflow.getAppName())
                        .getBPDProjectConfigMap().get(getOwnerProcess().getClassifications());
                pe.setProperty(PluginType.Classification.getType(), classification);
                pe.setBpdElement(manager.getBPDElement((String) entry.getKey()));
                Map params = manager.getPluginParams((String) entry.getKey());

                for (Iterator paramIt = params.entrySet().iterator(); paramIt.hasNext(); ) {
                    Map.Entry param = (Map.Entry) paramIt.next();
                    pe.setProperty((String) param.getKey(), ((CParameter) param.getValue()).getParameterValue());
                }
                pe.loadProperties();
                // plugins.put((String) entry.getKey(), pe);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    // 根据key取得内部资源
    public Object getProperty(String key) {
        return properties.get(key);
    }

    // 设置内部资源
    public void setProperty(String key, Object obj) {
        properties.put(key, obj);
    }

    public void refreshPlugins() {
        loadPlugins();
        fillPlugins();
    }

    // 插件的clone方法
    public Activity clonePlugins(Activity act) {
        // if (getType() == 2) {
        act.plugins = new HashMap();
        for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry entry = (Map.Entry) it.next();
            String name = (String) entry.getKey();
            Object val = entry.getValue();
            Object cloneVal = ((PluginElement) val).clone();
            act.complexStructure.add(cloneVal);
            act.plugins.put(name, cloneVal);
        }
        // }
        return act;
    }

    public void setWorkflowProcess(WorkflowProcess wp) {
        this.myWorkflow = wp;
    }

    public Set getNonExceptionalOutgoingTransitions() {
        Transitions ts = (Transitions) getCollection().getOwner().get("Transitions");
        outgoingTransitions = ts.getTransitions(getID(), -1);
        Set nonExceptionalOutgoingTransitions = new HashSet();
        Iterator it = outgoingTransitions.iterator();
        while (it.hasNext()) {
            Transition t = (Transition) it.next();
            Condition condition = (Condition) t.get("Condition");
            String condType = condition.get("Type").toValue().toString();
            if (!(condType.equals(RouteCondition.EXCEPTION.getType())
                    || condType.equals(RouteCondition.DEFAULTEXCEPTION.getType()))) {
                nonExceptionalOutgoingTransitions.add(t);
            }
        }
        return nonExceptionalOutgoingTransitions;
    }

    public Set getIncomingTransitions() {
        Transitions ts = (Transitions) getCollection().getOwner().get("Transitions");
        return ts.getTransitions(getID(), 1);
    }

    public XMLAttribute getAttrName() {
        return attrName;
    }

    public void setAttrName(XMLAttribute attrName) {
        this.attrName = attrName;
    }
}

/* End of Activity.java */
