/*
 * Created on 2005-12-23
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2005 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: SelectOption类，用于存储name和text
 * </p>
 * <p>
 * Copyright: Copyright (c) 2005
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2005-12-23 17:23:59
 * @version 1.0
 */

public class XMLSelectOption extends XMLElement {
	private String name;

	private String text;

	private String path;

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public XMLSelectOption() {
		super();
	}

	public XMLSelectOption(String name, String text) {
		this.name = name;
		this.text = text;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public String toString() {
		return name;
	}

	// 实现equals方法
	public boolean equals(Object o) {
		if (o == null || !(o instanceof XMLSelectOption)) {
			return false;
		}
		XMLSelectOption tmp = (XMLSelectOption) o;
		return (tmp.getName().equals(name) && tmp.getText().equals(text));
	}

	public String toLabel() {
		return name;
	}
}
