/* XMLComplexElement.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：由基本XML元素组成的复杂XML元素构造类
 * Authors： wenzhang li
 * Company： 基督山BPM
 *  CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import javax.swing.tree.DefaultMutableTreeNode;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents the complex XML element. For e.g., the following definition within XML schema:
 *
 * <pre>
 *
 *   &lt;xsd:element name=&quot;DataField&quot;&gt;
 *      &lt;xsd:complexType&gt;
 *         &lt;xsd:sequence&gt;
 *            &lt;xsd:element ref=&quot;DataType&quot;/&gt;
 *            &lt;xsd:element ref=&quot;InitialValue&quot; minOccurs=&quot;0&quot;/&gt;
 *            &lt;xsd:element ref=&quot;Length&quot; minOccurs=&quot;0&quot;/&gt;
 *            &lt;xsd:element ref=&quot;Description&quot; minOccurs=&quot;0&quot;/&gt;
 *            &lt;xsd:element ref=&quot;ExtendedAttributes&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;/xsd:sequence&gt;
 *         &lt;xsd:attribute name=&quot;Id&quot; type=&quot;xsd:NMTOKEN&quot; use=&quot;required&quot;/&gt;
 *         &lt;xsd:attribute name=&quot;Name&quot; type=&quot;xsd:string&quot;/&gt;
 *         &lt;xsd:attribute name=&quot;IsArray&quot; default=&quot;FALSE&quot;&gt;
 *            &lt;xsd:simpleType&gt;
 *               &lt;xsd:restriction base=&quot;xsd:NMTOKEN&quot;&gt;
 *                  &lt;xsd:enumeration value=&quot;TRUE&quot;/&gt;
 *                  &lt;xsd:enumeration value=&quot;FALSE&quot;/&gt;
 *               &lt;/xsd:restriction&gt;
 *            &lt;/xsd:simpleType&gt;
 *         &lt;/xsd:attribute&gt;
 *      &lt;/xsd:complexType&gt;
 *   &lt;/xsd:element&gt;
 *
 * </pre>
 * <p>
 * will be presented as the object of the class derived from this class, and the name of the class will be DataField.
 * The DataField object will have the other objects which are instances of XMLElement class that will be placed within
 * it's collection {@link #complexStructure}. These elements, in this particular case, will be the instances of
 * {@link XMLAttribute} class (that will be also placed into another collection - {@link #attributes}) which will
 * represent the 'Id', 'Name' and 'IsArray' XML attribute, the instances of classes <b>InitialValue</b>, <b>Length</b>,
 * <b>Description</b> which are all derived from {@link XMLSimpleElement} class and represents corresponding XML simple
 * elements, and the instances of classes <b>DataType</b> and <b>ExtendedAttributes</b>, which are also derived from
 * <code>XMLComplexElement</code> class.
 * <p>
 * The panels of elements that instance of <code>XMLComplexElement</code> class contains in it's
 * {@link #complexStructure} collection, will be placed on it's panel, which allows it's editing.
 * <p>
 * When writting or reading XML document, the {@link #complexStructure} will be used to write/read all required
 * elements.
 * <p>
 * The methods for setting or getting the value of each element by it's name, or by it's position within
 * {@link #complexStructure} collectioin is provided.
 * <p>
 * NOTE: Although this class is not declared abstract, it is uselles without redefining it's method
 * {@link #fillStructure}. The classes derived from this class corresponds to the complex XML element.
 */
public class XMLComplexElement extends XMLElement {

    /**
     * The list of all elements (attributes, and other elements) that complex element is consisted of.
     */
    protected List complexStructure = new ArrayList();

    /**
     * The list of attributes that complex element contains.
     */
    protected List attributes = new ArrayList();

    public XMLComplexElement() {
        super();
    }

    /**
     * Returns the collection of elements this element is made of.
     */
    public Collection toComplexType() {
        return complexStructure;
    }

    /**
     * Returns the collection of strings that represents elements that this element is made of.
     */
    public Collection toComplexTypeValues() {
        List l = new ArrayList();
        Iterator it = complexStructure.iterator();
        while (it.hasNext()) {
            XMLElement el = (XMLElement) it.next();
            if (el instanceof XMLAttribute) {
                l.add(el.toString());
            } else {
                l.add(el.toValue());
            }
        }
        return l;
    }

    public Collection toComplexValues() {
        List l = new ArrayList();

        Iterator it = complexStructure.iterator();
        while (it.hasNext()) {
            XMLElement el = (XMLElement) it.next();
            l.add(el.toValue());
        }
        return l;
    }

    /**
     * Sets the element and all elements it is made of to be read only or not.
     */
    public void setReadOnly(boolean ro) {
        super.setReadOnly(ro);
        Iterator it = complexStructure.iterator();
        while (it.hasNext()) {
            XMLElement el = (XMLElement) it.next();
            el.setReadOnly(ro);
        }
    }

    public boolean isEmpty() {
        boolean isEmpty = true;
        Iterator it = complexStructure.iterator();
        while (it.hasNext()) {
            XMLElement el = (XMLElement) it.next();
            isEmpty = isEmpty && el.isEmpty();
        }
        return isEmpty;
    }

    public boolean isValid() {
        boolean isValid = true;
        Iterator it = complexStructure.iterator();
        while (it.hasNext()) {
            XMLElement el = (XMLElement) it.next();
            isValid = isValid && el.isValid();
        }
        return isValid;
    }

    public void toXML(Node parent) throws DOMException {
        if (parent != null) {
            Node node = null;
            if (parent.getOwnerDocument() != null) {
                node = (parent.getOwnerDocument()).createElement(name);
            } else {
                node = ((Document) parent).createElement(name);
            }

            // Element easElem = (Element) XMLUtility.getFirstChild(node,
            // "ExtendedAttributes");
            // Document doc = node.getOwnerDocument();
            //
            // if (easElem == null) {
            // easElem = doc.createElement("ExtendedAttributes");
            // node.appendChild(easElem);
            // }

            for (Iterator it = complexStructure.iterator(); it.hasNext(); ) {
                XMLElement el = (XMLElement) it.next();
                el.toXML(node);
            }
            parent.appendChild(node);
        }
    }

    public void fromXML(Node node) {
        processAttributes(node);
        processElements(node);
    }

    protected void processAttributes(Node node) {
        if (node != null) {
            if (node.hasAttributes()) {
                NamedNodeMap attribs = node.getAttributes();
                for (int i = 0; i < attribs.getLength(); ++i) {
                    Node attrib = (Node) attribs.item(i);
                    try {
                        // System.out.println("Getting
                        // attrib"+attrib.getNodeName()+attrib.getNodeValue());
                        if (get(attrib.getNodeName()) != null) {
                            get(attrib.getNodeName()).fromXML(attrib);
                            // for(int k=0;k<this.attributes.size();k++){
                            // try {
                            //
                            // XMLAttribute att=(XMLAttribute)
                            // attributes.get(k);
                            // if (att.name.equals(attrib.getNodeName())){
                            // att.setValue(attrib.getNodeValue());
                            // }
                            //
                            // }catch(Exception npe){
                            //
                            // }
                            // }

                        }

                    } catch (NullPointerException npe) {
                        /*
                         * if (attribute.getNodeValue().trim().length() > 0 ) { System.err.println(
                         * "Processing attributes for "+ name +" element having problems with " +
                         * attribute.getNodeName()+" attribute\n" + attribute.getNodeValue().trim()); }
                         */
                    }
                }
            }
        }
    }

    protected void processElements(Node node) {
        if (node != null) {
            if (node.hasChildNodes()) {
                XMLUtil.parseElements(node, complexStructure);

            }
        }
    }

    public XMLPanel getPanel() {
        XMLElement[] c = new XMLElement[complexStructure.size()];
        complexStructure.toArray(c);
        return new XMLGroupPanel(this, c, toLabel());
    }

    /**
     * Gets the element that is placed at specified no. within structure.
     */
    public XMLElement get(int no) {
        try {
            return (XMLElement) complexStructure.get(no);
        } catch (Exception ex) {
            return null;
        }
    }

    /**
     * Sets the element that is placed at specified no. within structure to the specified value.
     */
    public void set(int no, Object value) {
        XMLElement el;
        try {
            el = get(no);
        } catch (Exception ex) {
            el = null;
        }
        if (el != null) {
            el.setValue(value);
        }
    }

    /**
     * Gets the element with specified name from stucture.
     */
    public XMLElement get(String name) {
        Iterator it = complexStructure.iterator();
        while (it.hasNext()) {
            XMLElement el = (XMLElement) it.next();

            if (el != null && el.name != null && el.name.equalsIgnoreCase(name)) {
                return el;
            }
        }
        return null;
    }

    /**
     * Sets the element with specified name from stucture to the specified value.
     */
    public void set(String name, Object value) {
        XMLElement el = get(name);
        if (el != null) {
            el.setValue(value);
        }
    }

    public String toString() {
        if (labelName != null) {
            return labelName;
        } else {
            return "";
        }
    }

    /**
     * The classes that are derived from this class has to give its definition for this method. It is used to insert all
     * members of those classes that are derived from XMLElement class (or classes that are derived from that class)
     * into one list, and the members that are derived from XMLAttribute class also to insert into other list. Many
     * methods of this class uses those lists: <code>toXML</code> method uses them to properly write an element tag to
     * the XML file, <code>fromXML</code> method uses them to properly read an element tag from the XML file,
     * <code>getPanel</code> method uses them to properly display members of this class, <code>get</code> and
     * <code>set</code> uses them to properly retrieve/set the elements from list, ... and so on
     * <p>
     * NOTE: The order of inserted elements is relevant for XML to be valid (members of classes derived from this class
     * must be inserted into first mentioned list in the same order that they are within a corresponding tag for those
     * classes within WfMC XML).
     */
    protected void fillStructure() {
        return;
    }

    /**
     * Count child elements of this complex element.
     *
     * @return count of subelements.
     */
    public int getElementsCount() {
        int elementsCount = 0;
        for (int i = 0; i < this.complexStructure.size(); i++) {
            if (!this.attributes.contains(this.complexStructure.get(i))) {
                elementsCount++;
            }
        }
        return elementsCount;
    }

    /**
     * Return element child nodes, without attributes.
     *
     * @return list with subelements.
     */
    public List getChildElements() {
        List list = new ArrayList();
        for (int i = 0; i < this.complexStructure.size(); i++) {
            if (!this.attributes.contains(this.complexStructure.get(i))) {
                list.add(this.complexStructure.get(i));
            }
        }
        return list;
    }

    // prepeares cloning for extended classes
    public Object clone() {
        XMLComplexElement d = (XMLComplexElement) super.clone();
        d.complexStructure = new ArrayList();
        d.attributes = new ArrayList();

        return d;
    }

    public void refreshLabelName() {
        super.refreshLabelName();
        Iterator itCs = complexStructure.iterator();
        while (itCs.hasNext()) {
            XMLElement el = (XMLElement) itCs.next();
            el.refreshLabelName();
        }
    }

    // 取得名称为name的元素位置
    public int getIndex(String name) {
        int index = -1;
        for (int i = 0; i < complexStructure.size(); i++) {
            XMLElement el = (XMLElement) complexStructure.get(i);
            if (el.name.equals(name)) {
                index = i;
                break;
            }
        }
        return index;
    }

    /**
     * DefaultMutableTreeNode with all subnodes of this element.
     *
     * @return return node with subelements.
     */
    public DefaultMutableTreeNode getNode() {
        DefaultMutableTreeNode node = new ToNameMutableTreeNode(this);
        for (int i = 0; i < this.complexStructure.size(); i++) {
            if (!this.attributes.contains(this.complexStructure.get(i))) {
                if (this.complexStructure.get(i) == null) {
                    try {
                        throw new Throwable();
                    } catch (Throwable e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    }
                }
                node.add(((XMLElement) this.complexStructure.get(i)).getNode());
            }
        }
        return node;
    }
}

/* End of XMLComplexElement.java */
