/* XMLCollectionElement.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */


package com.ds.bpm.bpd.xml;

import com.ds.bpm.bpd.xml.panels.NewXMLPanel;

import org.w3c.dom.Node;

/**
* Represents an XML element that belongs to some collection.
* Such element always has the 'Id' attribute.
*/
public class NewXMLCollectionElement extends NewXMLComplexElement {

   public static final String ID_DELIMITER="_";

   protected XMLAttribute attrId=new XMLAttribute("Id"); //required
   protected transient NewXMLCollection myCollection;

   // element by itself doesn't fill the structure - it is up
   // to extended classes to do it
   public NewXMLCollectionElement (NewXMLCollection myCollection) {
      super();

      this.myCollection=myCollection;
      try {
         attrId.setValue(myCollection.generateID());
      } catch (Exception ex) {} // this happens when collection is null
   }

   public String getID() {
      return attrId.value.toString();
   }

   public NewXMLCollection getCollection () {
      return myCollection;
   }

   protected void fillStructure () {
      attrId.setRequired(true);

      complexStructure.add(attrId);
      attributes.add(attrId);
   }

   public void fromXML(Node node) {
      super.fromXML(node);
      myCollection.updateID(getID());
   }

   public boolean isIDUniqueAndValid (NewXMLPanel panelToEdit) {
      return true;
   }

   // I think that clone is not needed here because of constructor
   // add cloned attributes to attributes list
   public Object clone () {
      NewXMLCollectionElement d=(NewXMLCollectionElement)super.clone();
      d.attrId=(XMLAttribute)this.attrId.clone();
      d.myCollection=this.myCollection;
      return d;
   }

}

/* End of XMLCollectionElement.java */
