/* XMLTablePanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */


package com.ds.bpm.bpd.wfxml;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import java.util.Vector;

import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.NewXMLCollection;
import com.ds.bpm.bpd.xml.NewXMLComplexElement;
import com.ds.bpm.bpd.xml.NewXMLElement;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.NewXMLPanel;
import com.ds.bpm.bpd.xml.panels.NewXMLTablePanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;


/**
 * Creates a table panel.
 */
public class WfXMLPanel extends NewXMLPanel {

   NewXMLTablePanel lstPanel;
   WfXMLComboPanel cboPanel;

   public WfXMLPanel (NewXMLCollection myOwner) {

      super(myOwner,1,"",XMLPanel.BOX_LAYOUT,true,false);

      cboPanel=new WfXMLComboPanel(myOwner);

      lstPanel=new NewXMLTablePanel (myOwner,myOwner.toLabel(),false,true,false,false,false);

      add(cboPanel);
      add(Box.createRigidArea(new Dimension(0,10)));
      add(lstPanel);

      setPreferredSize(new Dimension(850,500));

      XMLButton buttonConnect=cboPanel.getConnectButton();
      final JComboBox jcb=cboPanel.getComboBox();
      // action listener for connecting to registry service
      buttonConnect.addActionListener(new ActionListener(){
               public void actionPerformed(ActionEvent ae){
                  String selected=(String)jcb.getSelectedItem();
                  DefInfos dis=(DefInfos)getOwner();
                  if (selected!=null) {
                     try {
                        List l=WfXMLConnector.wfxmlListDefinitions(new URL(selected),dis);
                        cleanTable();
                        for (int i=0; i<l.size(); i++) {
                           addElement((NewXMLElement)l.get(i));
                        }
                        BPD.getInstance().message(ResourceManager.getLanguageDependentString("InformationWfXMLSuccessfullyConnectedToRegistryService")+" "+selected,JOptionPane.INFORMATION_MESSAGE);
                     } catch (Exception ex) {
                        ex.printStackTrace();
                        BPD.getInstance().message(ResourceManager.getLanguageDependentString("ErrorWfXMLProblemsWhileGettingDefinitionListForRegistry")+" "+selected+" !",JOptionPane.ERROR_MESSAGE);
                     }
                  } else {
                     complainLoudly("WarningEmptySelectionToEditOrDelete");
                  }
               }
            });



   }

   public NewXMLPanel getControlledPanel () {
      return lstPanel;
   }

   public WfXMLComboPanel getComboPanel () {
      return cboPanel;
   }

   /**
    * Pops message into message dialog.
    */
   public void complainLoudly(String message) {
      JOptionPane.showMessageDialog(getDialog(),
                                    XMLUtil.getLanguageDependentString(message),
                                    XMLUtil.getLanguageDependentString("Title"),
                                    JOptionPane.WARNING_MESSAGE);
   }

   public void cleanTable () {
      ((NewXMLCollection)getOwner()).clear();
      JTable t=lstPanel.getTable();
      DefaultTableModel dtm=(DefaultTableModel)t.getModel();
      int rc=dtm.getRowCount();
      for (int i=rc-1; i>=0; i--) {
         dtm.removeRow(i);
      }
   }

   public void addElement(NewXMLElement e) {
      NewXMLCollection owncol=(NewXMLCollection)getOwner();
      int rowpos=owncol.size();
      owncol.add(e);
      JTable t=lstPanel.getTable();
      DefaultTableModel dtm=(DefaultTableModel)t.getModel();
      Vector v=null;
      if (e instanceof NewXMLComplexElement) {
         v=new Vector(((NewXMLComplexElement)e).toComplexTypeValues());
      } else {
         v=new Vector();
         v.add(e.toString());
      }

      // add object itself to the first column (it is invisible column)
      v.add(0,e);
      dtm.insertRow(rowpos,v);
      //dtm.addRow(v);
      try {
         //t.setRowSelectionInterval(t.getRowCount()-1,t.getRowCount()-1);
         t.setRowSelectionInterval(rowpos,rowpos);
      } catch (Exception ex) {}
      t.requestFocus();
   }

   public XMLElement getSelectedElement() {
      return lstPanel.getSelectedElement();
   }


   public Object getSelectedItem () {
      Object si=cboPanel.getComboBox().getSelectedItem();
      System.out.println("Si="+si);
      return si;
   }

}

