/* XMLActualParametersListControlPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */


package com.ds.bpm.bpd.wfxml;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;

import javax.swing.Box;
import javax.swing.JOptionPane;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.NewXMLCollection;
import com.ds.bpm.bpd.xml.NewXMLElement;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.NewXMLControlPanel;

/**
 * Creates a control panel for table panel.
 */
public class WfXMLControlPanel extends NewXMLControlPanel {
   public WfXMLControlPanel (NewXMLCollection myOwner,
                             final WfXMLPanel cont,
                             String title,
                             boolean isVertical,
                             boolean hasBorder) {

      super(myOwner,title,isVertical,hasBorder);

      controlledPanel=cont.getControlledPanel();

      String d=XMLUtil.getLanguageDependentString("DownloadKey");
      String up=XMLUtil.getLanguageDependentString("UploadKey");
      String u=XMLUtil.getLanguageDependentString("UpdateKey");

      Dimension dim=getPreferredDimension(new String[]{d,u,up});

      XMLButton buttonDownload=new XMLButton(d,"Download",dim);
      XMLButton buttonUpload=new XMLButton(up,"Upload",dim);
      XMLButton buttonUpdate=new XMLButton(u,"Update",dim);

      add(Box.createHorizontalGlue());
      add(buttonDownload);
      add(Box.createRigidArea(new Dimension(10,0)));
      add(buttonUpload);
      add(Box.createRigidArea(new Dimension(10,0)));
      add(buttonUpdate);
      add(Box.createRigidArea(new Dimension(10,0)));
      add(Box.createRigidArea(new Dimension(0,25)));

      add(Box.createHorizontalGlue());


      // action listener for downloading XPDL
	  
	  /*
      buttonDownload.addActionListener(new ActionListener() {
               public void actionPerformed(ActionEvent ae) {
                  String selected=((XMLComplexElement)cont.getSelectedElement()).get("DefinitionKey").toString();
                  if (selected!=null) {
                     try {
                        Node n=WfXMLConnector.wfxmlGetDefinition(new URL(selected));
                        String pkgCnt=WfXMLConnector.node2String(n);
                        String pkgId=XMLUtil.getID(n);

                      //  BPD.getInstance().openPackageFromStream(pkgId,pkgCnt);
						 BPD.getInstance().openDocument(pkgId,false,true);

                        BPD.getInstance().message(pkgId+" - "+ResourceManager.getLanguageDependentString("InformationWfXMLXPDLIsSucessfullyDownloaded"),JOptionPane.INFORMATION_MESSAGE);

                     } catch (Exception ex) {
                        ex.printStackTrace();
                        BPD.getInstance().message(ResourceManager.getLanguageDependentString("ErrorWfXMLProblemsWhileDownloadingXPDL")+" "+selected+" !",JOptionPane.ERROR_MESSAGE);
                     }
                  } else {
                     cont.complainLoudly("WarningEmptySelectionToEditOrDelete");
                  }
               }
            });
*/
      // action listener for uploading XPDL
      buttonUpload.addActionListener(new ActionListener() {
               public void actionPerformed(ActionEvent ae) {
                  String pkgId=BPD.getInstance().getRealXMLPackage().get("Id").toString();
                  String selected=(String)cont.getSelectedItem();
                  if (selected!=null && pkgId!=null && !pkgId.trim().equals("")) {
                     try {
                        String pkgContent=WfXMLConnector.xpdlToString();
                        WfXMLConnector.wfxmlNewDefinition2(new URL(selected),pkgContent);
                        BPD.getInstance().message(pkgId+" - "+ResourceManager.getLanguageDependentString("InformationWfXMLXPDLIsSucessfullyUploaded"),JOptionPane.INFORMATION_MESSAGE);
                     } catch (Exception ex) {
                        ex.printStackTrace();
                        BPD.getInstance().message(ResourceManager.getLanguageDependentString("ErrorWfXMLProblemsWhileUploadingXPDL")+" "+selected+" !",JOptionPane.ERROR_MESSAGE);
                        return;
                     }
                     try {
                        DefInfos dis=(DefInfos)getOwner();
                        List l=WfXMLConnector.wfxmlListDefinitions(new URL(selected),dis);
                        cont.cleanTable();
                        for (int i=0; i<l.size(); i++) {
                           cont.addElement((NewXMLElement)l.get(i));
                        }
                     } catch (Exception ex) {
                        ex.printStackTrace();
                        BPD.getInstance().message(ResourceManager.getLanguageDependentString("ErrorWfXMLProblemsWhileGettingDefinitionListForRegistry")+" "+selected+" !",JOptionPane.ERROR_MESSAGE);
                     }

                  } else {
                     cont.complainLoudly("WarningEmptySelectionToEditOrDelete");
                  }
               }
            });

      // action listener for updating XPDL
      buttonUpdate.addActionListener(new ActionListener() {
               public void actionPerformed(ActionEvent ae) {
                  String pkgId=BPD.getInstance().getRealXMLPackage().get("Id").toString();
                  if (cont.getSelectedElement()!=null && pkgId!=null && !pkgId.trim().equals("")) {
                     String selected=((XMLComplexElement)cont.getSelectedElement()).get("DefinitionKey").toString();
                     try {
                        String pkgContent=WfXMLConnector.xpdlToString();
                        WfXMLConnector.wfxmlSetDefinition2(new URL(selected),pkgContent);
                        BPD.getInstance().message(pkgId+" - "+ResourceManager.getLanguageDependentString("InformationWfXMLXPDLIsSucessfullyUpdated"),JOptionPane.INFORMATION_MESSAGE);
                     } catch (Exception ex) {
                        ex.printStackTrace();
                        BPD.getInstance().message(ResourceManager.getLanguageDependentString("ErrorWfXMLProblemsWhileUpdatingXPDL")+" "+selected+" !",JOptionPane.ERROR_MESSAGE);
                        return;
                     }
                     try {
                        selected=(String)cont.getSelectedItem();
                        DefInfos dis=(DefInfos)getOwner();
                        cont.cleanTable();
                        List l=WfXMLConnector.wfxmlListDefinitions(new URL(selected),dis);
                        for (int i=0; i<l.size(); i++) {
                           cont.addElement((NewXMLElement)l.get(i));
                        }
                     } catch (Exception ex) {
                        ex.printStackTrace();
                        BPD.getInstance().message(ResourceManager.getLanguageDependentString("ErrorWfXMLProblemsWhileGettingDefinitionListForRegistry")+" "+selected+" !",JOptionPane.ERROR_MESSAGE);
                     }

                  } else {
                     cont.complainLoudly("WarningEmptySelectionToEditOrDelete");
                  }
               }
            });
   }


}

