/* WfXMLComboPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.wfxml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;

import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;

import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.NewXMLElement;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.NewXMLComboPanel;
import com.ds.bpm.bpd.xml.panels.NewXMLPanel;

/**
 * Creates panel with JLabel and JComboBox.
 */
public class WfXMLComboPanel extends NewXMLComboPanel {

   private static final int MAX_URL_HISTORY_SIZE=16;

   private static String URL_HISTORY_FILE_PATH;
   private static ArrayList urls;

   private Dimension comboBoxDimension=new Dimension(350,20);

   private XMLButton buttonConnect;


   public WfXMLComboPanel (NewXMLElement myOwner) {

      super(myOwner,null,NewXMLPanel.BOX_LAYOUT,false,true);

      ((JLabel)getComponent(1)).setText(ResourceManager.getLanguageDependentString("RegistryServiceURL")+": ");

      if (URL_HISTORY_FILE_PATH==null) {
         URL_HISTORY_FILE_PATH=BPDConstants.BPD_USER_HOME+BPDConstants.RURL_FILENAME;
         File extR=new File(URL_HISTORY_FILE_PATH);
         if (extR.exists()) {
            urls=(ArrayList)readFile(URL_HISTORY_FILE_PATH);
         }
         if (urls==null) {
            urls=new ArrayList();
         }
      }

      final JComboBox jcb=super.getComboBox();
      for (int i=0; i<urls.size(); i++) {
         jcb.addItem(urls.get(i));
      }
      if (urls.size()>0) {
         jcb.setSelectedIndex(0);
      }
      jcb.setPreferredSize(comboBoxDimension);
      String s=XMLUtil.getLanguageDependentString("ConnectKey");
      double w=0;
      try {
         w=getFontMetrics(getFont()).stringWidth(s);
      } catch(Exception ex) {}
      double h=getFontMetrics(getFont()).getHeight();
      w+=25;
      if (w<30) w=30;
      Dimension dim=new Dimension((int)w,(int)h);

      buttonConnect=new XMLButton(s,"Connect",dim);
      buttonConnect.setAlignmentX(Component.LEFT_ALIGNMENT);
      buttonConnect.setAlignmentY(Component.BOTTOM_ALIGNMENT);

      add(Box.createRigidArea(new Dimension(10,0)));
      add(buttonConnect);

      buttonConnect.addActionListener(new ActionListener(){
               public void actionPerformed(ActionEvent ae){
                  String selected=(String)jcb.getSelectedItem();
                  if (selected!=null) {
                     addItemToCombo(selected);
                  }
               }
            });

   }

   public XMLButton getConnectButton () {
      return buttonConnect;
   }

   public void setElements () {
   }

   /**
    * Adds a text into combo box if it hasn't been there previously.
    */
   private void addItemToCombo (String url) {
      if (url==null || url.trim().length()==0) return;
      JComboBox jcb=getComboBox();
      for (int i=0; i<jcb.getItemCount(); i++) {
         if (jcb.getItemAt(i).toString().equals(url)) {
            jcb.removeItemAt(i);
            jcb.insertItemAt(url,0);
            jcb.setSelectedIndex(0);
            urls.remove(i);
            urls.add(0,url);
            writeFile(urls,URL_HISTORY_FILE_PATH);
            return;
         }
      }
      jcb.insertItemAt(url,0);
      urls.add(0,url);
      if (jcb.getItemCount()>MAX_URL_HISTORY_SIZE) {
         jcb.removeItemAt(MAX_URL_HISTORY_SIZE);
         urls.remove(MAX_URL_HISTORY_SIZE);
      }
      jcb.setSelectedIndex(0);
      writeFile(urls,URL_HISTORY_FILE_PATH);
   }

   private void writeFile (Object obj,String fName) {
      try {
         OutputStream fos = new FileOutputStream(fName);
         ObjectOutputStream oout = new ObjectOutputStream(fos);
         oout.writeObject(obj);
         oout.flush();
         oout.close();
         fos.close();
      } catch (Exception ex) {
         ex.printStackTrace();
      }
   }

   private Object readFile (String fName) {
      try {
         InputStream fis = new FileInputStream(fName);
         ObjectInputStream oin = new ObjectInputStream(fis);
         Object obj=oin.readObject();
         oin.close();
         return obj;
      } catch (Exception ex) {
         ex.printStackTrace();
         return null;
      }
   }


}

