package com.ds.bpm.bpd.service;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDLogFactory;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.client.ProcessDef;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.config.BPDProjectConfig;
import com.ds.config.CApplication;
import com.ds.org.Person;

import javax.swing.*;
import java.util.List;

public class CtBPDServiceImpl implements CtBPDService {

    private BPDService rmService;

    private transient Log logger = BPDLogFactory.getLog(this.getClass());

    private static List<CApplication> application;
    private static List<BPDProjectConfig> classifications;

    public CtBPDServiceImpl(BPDService rmService) {
        this.rmService = rmService;
    }

    @Override
    public List<CApplication> getAppLications() throws JDSException {
        // 缓存数据
        if (application == null) {
            application = rmService.getAppLications().get();
        }
        return application;
    }

    @Override
    public List<ProcessDef> getTempProcessDefList() throws JDSException {


        return rmService.getTempProcessDefList().getData();
    }

    @Override
    public List<BPDProjectConfig> getProcessClassifications() throws JDSException {
        if (classifications == null) {
            classifications = rmService.getProcessClassifications().getData();
        }
        return classifications;
    }

    @Override
    public List<ProcessDef> getProcessDefList(String projectName) throws JDSException {


        return rmService.getProcessDefList(projectName).getData();
    }

    @Override
    public Boolean saveProcessDefListToDB(String xpdlString) throws JDSException {
        return rmService.saveProcessDefListToDB(xpdlString).getData();
    }

    @Override
    public Boolean deleteProcessDefListToDB(String versionIdsString) throws JDSException {
        return rmService.deleteProcessDefListToDB(versionIdsString).getData();
    }

    @Override
    public String getProcessDefListFromDB(String versionIdsString) throws JDSException {
        return rmService.getProcessDefListFromDB(versionIdsString).getData();
    }

    @Override
    public Boolean activateProcessDefVersion(String versionId) throws JDSException {
        return rmService.activateProcessDefVersion(versionId).getData();
    }

    @Override
    public Boolean freezeProcessDefVersion(String processDefVersionId) throws JDSException {
        return rmService.freezeProcessDefVersion(processDefVersionId).getData();
    }

    @Override
    public Boolean saveCommission(String processId, String group, String personIds) throws JDSException {
        return rmService.saveCommission(processId, group, personIds).getData();
    }

    @Override
    public List<Person> getCommissions(String processId, String group) throws JDSException {
        return rmService.getCommissions(processId, group).getData();
    }

    @Override
    public void handleWebServiceException(JDSException e) {
        if (e.getErrorCode() == JDSException.NOTLOGINEDERROR && BPD.getInstance().isLogined()) {
            JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("WarningSessionIsInvalid"), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
            // 设置没有登陆标识
            BPD.getInstance().setLoginFlag(false);

            // 刷新界面
            BPD.getInstance().getPackageEditor().valueChanged(null);
        } else {
            String message = ResourceManager.getLanguageDependentString(e.getMessage());
            if (message == null || message.trim().equals("")) {
                JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("ErrorCannotConnectToWebService"), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);

            } else {
                JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString(e.getMessage()), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
            }
        }
        // 写日志
        logger.error("WebServiceException:" + e.getMessage());

    }

}
