package com.ds.bpm.bpd.service;

import com.ds.bpm.client.ProcessDef;
import com.ds.common.JDSException;
import com.ds.config.BPDProjectConfig;
import com.ds.config.CApplication;
import com.ds.org.Person;

import java.util.List;

public interface CtBPDService {

    public void handleWebServiceException(JDSException e);

    /**
     * 获取所有应用信息
     *
     * @return
     */
    public List<CApplication> getAppLications() throws JDSException;

    /**
     * 获取流程模板
     * 
     * @return
     */
    public List<ProcessDef> getTempProcessDefList() throws JDSException;

    /**
     * 获取流程分类配置
     * 
     * @return
     */
    public List<BPDProjectConfig> getProcessClassifications() throws JDSException;

    /**
     * 获取流程定义列表
     * 
     * @return
     */
    public List<ProcessDef> getProcessDefList(String projectName) throws JDSException;

    /**
     * 保存工作流信息到数据库
     * 
     * @param xpdlString
     *            XPDL文件的字符串
     * @return boolean
     */
    public Boolean saveProcessDefListToDB(String xpdlString) throws JDSException;

    /**
     * 删除数据库中的工作流信息
     * 
     * @param versionIdsString
     *            流程版本ID的字符串，以逗号分割
     * @return boolean
     */
    public Boolean deleteProcessDefListToDB(String versionIdsString) throws JDSException;

    /**
     * 从数据库中获得工作流XPDL字符串
     * 
     * @param versionIdsString
     *            流程版本ID的字符串，以逗号分割
     * @return xpdlString XPDL文件的字符串
     */
    public String getProcessDefListFromDB(String versionIdsString) throws JDSException;

    /**
     * 激活制定版本流程
     * 
     * @param versionId
     * @return
     */
    public Boolean activateProcessDefVersion(String versionId) throws JDSException;

    /**
     * 冻结指定版本流程
     * 
     * @param processDefVersionId
     * @return
     */
    public Boolean freezeProcessDefVersion(String processDefVersionId) throws JDSException;

    /**
     * 保存流程授权信息
     * 
     * @param processId
     *            流程Id
     *            流程授权信息
     * @return 成功返回true，否则返回false
     */
    public Boolean saveCommission(String processId, String group, String personIds) throws JDSException;

    /**
     * 获取指定流程的流程授权信息
     * 
     * @param processId
     *            流程Id
     * @return 流程授权信息Map
     */
    public List<Person> getCommissions(String processId, String group) throws JDSException;

}
