package com.ds.bpm.bpd.server.panels;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.MainLeftDownPanel;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.client.ProcessDef;
import com.ds.bpm.client.ProcessDefVersion;
import com.ds.bpm.engine.BPMException;
import com.ds.bpm.enums.process.ProcessDefVersionStatus;
import com.ds.common.JDSException;
import com.ds.common.swing.ProgressDialog;
import com.ds.common.swing.progress.Task;
import com.ds.common.swing.util.SwingWorker;

/**
 * Title : BPM工作流图形定义工具BPD Class Desription：远端服务器工作流列表界面类 Authors： wenzhang li Company： 基督山BPM CreatedTime：2005-12-6
 */
public class OpenRemoteDialog extends JDialog {

    // 流程列表的打开按钮
    private JButton buttonOpen;

    // 流程列表的删除按钮
    private JButton buttonDelete;

    // 流程列表的取消按钮
    private JButton buttonCancel;

    // 流程列表的高级按钮
    private JButton buttonAdvance;

    // 版本列表的新建按钮
    private JButton buttonCreate;

    // 版本列表的激活按钮
    private JButton buttonActivate;

    // 版本列表的冻结按钮
    private JButton buttonFreeze;

    private static Dimension processJListDimension = new Dimension(250, 150);

    private static Dimension versionJListDimension = new Dimension(250, 150);

    // 显示的主面板
    JPanel mainPanel;

    // 显示的子面板
    JPanel subMainPanel;

    private JPanel contentPanel;

    // 流程列表
    private JList processJList;

    // 流程版本列表
    private JList versionJList;

    // 流程版本列表面板
    private JPanel versionJListPanel;

    // 流程版本高级属性是否显示的标志位
    private boolean isShowAdvance = false;

    // 流程信息集合
    List<ProcessDef> processInfoList;

    // 版本信息集合
    List<ProcessDefVersion> versionInfoList;

    private Task task;

    private String remoteVersionId;

    // 流程最大版本UUID
    private String maxVersion = "1";

    // 新版本流程对象
    private WorkflowProcess newWp;

    /**
     * 对话框构造器
     * 
     * @param parentFrame
     *            父窗口.
     * @param title
     *            对话框标题.
     * @param isModal
     *            是否是模式.
     */
    public OpenRemoteDialog(JFrame parentFrame, String title, boolean isModal) {
	super(parentFrame, title, isModal);
	initDialog();
    }

    /**
     * 初始化界面
     */
    private void initDialog() {
	// 添加JDialog面板内容
	Container cp = getContentPane();
	cp.add(createContentPanel(), BorderLayout.CENTER);
	// 添加窗口侦听器
	addWindowListener(wl);
	getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false), "Cancel");
	getRootPane().getActionMap().put("Cancel", new AbstractAction() {

	    public void actionPerformed(ActionEvent e) {
		dispose();
	    }
	});
	setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
	setResizable(false);
	setLocationRelativeTo(getParent());
	buttonOpen.setDefaultCapable(true);
	getRootPane().setDefaultButton(buttonOpen);

    }

    /**
     * 返回远端服务器工作流显示内容面板
     * 
     * @return contentPanel (the JPanel of content )
     */
    private JPanel createContentPanel() {
	// 创建显示的主面板
	mainPanel = new JPanel();
	mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.X_AXIS));
	mainPanel.setAlignmentX(JPanel.CENTER_ALIGNMENT);
	mainPanel.add(createProcessListPanel());
	mainPanel.add(createProcessButtonGroupPanel());
	// 创建内容面板
	contentPanel = new JPanel();
	contentPanel.setLayout(new BorderLayout());
	contentPanel.add(mainPanel, BorderLayout.NORTH);
	// 返回内容面板
	return contentPanel;
    }

    /**
     * 返回远端服务器工作流列表面板
     * 
     * @return processJListPanel (the JPanel of processlist )
     */
    private JPanel createProcessListPanel() {
	JPanel processJListPanel = new JPanel();
	processJListPanel.setLayout(new BoxLayout(processJListPanel, BoxLayout.Y_AXIS));
	processJListPanel.setAlignmentX(JPanel.RIGHT_ALIGNMENT);
	// 工作流列表
	JScrollPane scrollProcessList = new JScrollPane();

	// 将工组流信息集添加到列表中
	processJList = new JList();
	DefaultListModel model = new DefaultListModel();
	// 获得流程定义信息集合
	processInfoList = BPD.getInstance().getRemoteProcessDefList(true);

	for (ProcessDef processDef : processInfoList) {

	    model.addElement(processDef.getName());
	}

	processJList.setToolTipText((String) processJList.getSelectedValue());
	processJList.setModel(model);
	// 默认选择第一项
	processJList.setSelectedIndex(0);
	processJList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	// 设置 scrollProcessList大小
	scrollProcessList.setViewportView(processJList);
	scrollProcessList.setPreferredSize(processJListDimension);
	scrollProcessList.setMinimumSize(processJListDimension);
	scrollProcessList.setAlignmentX(JPanel.LEFT_ALIGNMENT);
	// 列表标题
	JLabel processJListTitle = new JLabel(ResourceManager.getLanguageDependentString("RemoteProcessList.ProcessList.Name.display"));
	processJListTitle.setLabelFor(processJList);
	// 添加scrollProcessList到processJListPanel面板
	processJListPanel.add(processJListTitle);
	processJListPanel.add(Box.createRigidArea(new Dimension(0, 5)));
	processJListPanel.add(scrollProcessList);
	processJListPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
	// 创建流程列表的选择侦听器，当更换选择时，改变相应的鼠标提示
	processJList.addListSelectionListener(new ListSelectionListener() {

	    public void valueChanged(ListSelectionEvent lse) {
		JList list = (JList) lse.getSource();
		DefaultListModel listModel = (DefaultListModel) list.getModel();
		int selectedIndex = -1;
		try {
		    selectedIndex = list.getSelectedIndex();
		} catch (Exception ex) {
		    ex.printStackTrace();
		}
		if (selectedIndex != -1) {
		    String processname = (String) listModel.elementAt(selectedIndex);
		    list.setToolTipText(processname);
		}
	    }
	});
	// 创建流程列表的鼠标点击侦听器，点击时更换流程版本列表的值
	processJList.addMouseListener(new MouseAdapter() {

	    public void mouseClicked(MouseEvent me) {
		if (isShowAdvance) {
		    JList theList = (JList) me.getSource();
		    ListModel model = theList.getModel();
		    int selectedIndex = theList.locationToIndex(me.getPoint());
		    // 获得版本列表JList对象
		    versionJList = getVersionListModelOfSelProcess(selectedIndex);
		    // 重新刷新版本列表
		    refreshVersionJList(versionJList);
		}
	    }
	});
	// 返回面板
	return processJListPanel;
    }

    /**
     * 返回远端服务器工作流版本列表面板
     * 
     * @return versionJListPanel (the JPanel of versionlist )
     */
    private JPanel createVersionListPanel() {
	// 获得工作流版本面板
	versionJListPanel = new JPanel();
	versionJListPanel.setLayout(new BoxLayout(versionJListPanel, BoxLayout.Y_AXIS));
	versionJListPanel.setAlignmentX(JPanel.RIGHT_ALIGNMENT);
	// 获得工作流版本滚动面板
	JScrollPane scrollVersionList = new JScrollPane();
	// 获得工作流版本列表
	versionJList = getVersionListModelOfSelProcess(processJList.getSelectedIndex());

	// 创建流程版本列表的选择侦听器，当更换选择时，改变相应的鼠标提示
	versionJList.addListSelectionListener(new ListSelectionListener() {

	    public void valueChanged(ListSelectionEvent lse) {
		JList list = (JList) lse.getSource();
		DefaultListModel listModel = (DefaultListModel) list.getModel();
		int selectedIndex = -1;
		try {
		    selectedIndex = list.getSelectedIndex();
		} catch (Exception ex) {
		    ex.printStackTrace();
		}
		if (selectedIndex != -1) {
		    String versionname = (String) listModel.elementAt(selectedIndex);
		    list.setToolTipText(versionname);
		}
	    }
	});
	// 设置 scrollVersionList大小
	scrollVersionList.setViewportView(versionJList);
	scrollVersionList.setPreferredSize(versionJListDimension);
	scrollVersionList.setMinimumSize(versionJListDimension);
	scrollVersionList.setAlignmentX(JPanel.LEFT_ALIGNMENT);
	// 列表标题
	JLabel versionJListTitle = new JLabel(ResourceManager.getLanguageDependentString("RemoteProcessList.VersionList.Name.display"));
	versionJListTitle.setLabelFor(versionJList);
	// 添加scrollVersionList到versionJListPanel面板
	versionJListPanel.add(Box.createRigidArea(new Dimension(0, 5)));
	versionJListPanel.add(versionJListTitle);
	versionJListPanel.add(Box.createRigidArea(new Dimension(0, 5)));
	versionJListPanel.add(scrollVersionList);
	versionJListPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
	// 返回面板
	return versionJListPanel;
    }

    /**
     * 创建流程列表的按钮组面板
     * 
     * @return processButtonGroupPanel (the JPanel of buttongroup )
     */
    private JPanel createProcessButtonGroupPanel() {
	JPanel processButtonGroupPanel = new JPanel();
	processButtonGroupPanel.setLayout(new BoxLayout(processButtonGroupPanel, BoxLayout.Y_AXIS));
	processButtonGroupPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
	// buttonGroupPanel.setPreferredSize(buttonPanelDimension);
	// 创建打开按钮
	buttonOpen = new JButton(ResourceManager.getLanguageDependentString("RemoteProcessList.OpenButton.Name.display"));
	buttonOpen.setFont(BPDConfig.getInstance().getFont());
	URL u = ResourceManager.getResource("OpenRemoteImage");
	if (u != null) {
	    buttonOpen.setIcon(new ImageIcon(u));
	}
	// 为打开按钮添加侦听器
	buttonOpen.addActionListener(new ActionListener() {

	    public void actionPerformed(ActionEvent ae) {
		// 获得选择的版本ID
		ProcessDefVersion processDefVersion;
		if (!isShowAdvance) {
		    // 如果没有显示高级选项，就直接打开流程默认版本

		    ProcessDef processDef = processInfoList.get(processJList.getSelectedIndex());

		    try {
			versionInfoList = processDef.getAllProcessDefVersions();
		    } catch (BPMException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		    }
		    int maxVersionIndex = 0;
		    int maxVersion = 0;
		    for (int i = 0; i < versionInfoList.size(); i++) {
			// 获得版本状态
			processDefVersion = (ProcessDefVersion) versionInfoList.get(i);
			if (processDefVersion.getPublicationStatus().equals(ProcessDefVersionStatus.RELEASED)) {
			    remoteVersionId = processDefVersion.getProcessDefVersionId();
			    break;
			} else {
			    if (processDefVersion.getVersion() > maxVersion) {
				maxVersion = processDefVersion.getVersion();
				remoteVersionId = processDefVersion.getProcessDefVersionId();
			    }
			}
		    }

		} else {
		    if (versionInfoList != null && versionInfoList.size() != 0) {
			processDefVersion = (ProcessDefVersion) versionInfoList.get(versionJList.getSelectedIndex());
			remoteVersionId = processDefVersion.getProcessDefVersionId();
		    }
		}
		if (remoteVersionId != null && BPD.getInstance().isProcessOpenedAfresh(BPDConstants.PROCESS_REMOTE, remoteVersionId)) {

		    // 从服务器获取流程的进程
		    task = new OpenProcessTask();
		    dispose();
		    SwingUtilities.invokeLater(new Runnable() {

			public void run() {
			    String progressTitle = ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Title.Name.display");
			    String progressDescription = ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Description.Name.display");
			    String progressMessage = ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Message.Name.display");
			    ProgressDialog progressDialog = new ProgressDialog((JFrame) getParent(), progressTitle, progressDescription, progressMessage, task, 0, false);
			    progressDialog.dispose();
			}
		    });
		    task.go();
		}
	    }
	});
	// 创建删除按钮
	buttonDelete = new JButton(ResourceManager.getLanguageDependentString("RemoteProcessList.DeleteRemoteButton.Name.display"));
	buttonDelete.setFont(BPDConfig.getInstance().getFont());
	u = ResourceManager.getResource("DeleteRemoteImage");
	if (u != null) {
	    buttonDelete.setIcon(new ImageIcon(u));
	}
	// 为删除按钮添加侦听器
	buttonDelete.addActionListener(new ActionListener() {

	    public void actionPerformed(ActionEvent ae) {
		deleteRemoteWorkflowProcesses();
		// dispose();
	    }
	});
	// 创建取消按钮
	buttonCancel = new JButton(ResourceManager.getLanguageDependentString("RemoteProcessList.CancelButton.Name.display"));
	buttonCancel.setFont(BPDConfig.getInstance().getFont());
	u = ResourceManager.getResource("CancelImage");
	if (u != null) {
	    buttonCancel.setIcon(new ImageIcon(u));
	}
	// 为取消按钮添加侦听器
	buttonCancel.addActionListener(new ActionListener() {

	    public void actionPerformed(ActionEvent ae) {
		dispose();
	    }
	});
	// 创建高级按钮
	buttonAdvance = new JButton(ResourceManager.getLanguageDependentString("RemoteProcessList.AdvanceButton.Name.display"));
	buttonAdvance.setFont(BPDConfig.getInstance().getFont());
	u = ResourceManager.getResource("AdvanceImage");
	if (u != null) {
	    buttonAdvance.setIcon(new ImageIcon(u));
	}
	// 为高级按钮添加侦听器
	buttonAdvance.addActionListener(new ActionListener() {

	    public void actionPerformed(ActionEvent ae) {
		showAdvancePanel();
	    }
	});
	// 在按钮之间加空格
	processButtonGroupPanel.add(Box.createVerticalStrut(10));
	processButtonGroupPanel.add(buttonOpen);
	// 在按钮之间加空格
	processButtonGroupPanel.add(Box.createVerticalStrut(10));
	processButtonGroupPanel.add(buttonDelete);
	// 在按钮之间加空格
	processButtonGroupPanel.add(Box.createVerticalStrut(10));
	processButtonGroupPanel.add(buttonCancel);
	// 在按钮之间加空格
	processButtonGroupPanel.add(Box.createVerticalStrut(40));
	processButtonGroupPanel.add(buttonAdvance);
	return processButtonGroupPanel;
    }

    /**
     * 创建版本列表的按钮组面板
     * 
     * @return versionButtonGroupPanel (the JPanel of buttongroup )
     */
    private JPanel createVersionButtonGroupPanel() {
	JPanel versionButtonGroupPanel = new JPanel();
	versionButtonGroupPanel.setLayout(new BoxLayout(versionButtonGroupPanel, BoxLayout.Y_AXIS));
	versionButtonGroupPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
	// buttonGroupPanel.setPreferredSize(buttonPanelDimension);
	// 创建新建版本按钮
	buttonCreate = new JButton(ResourceManager.getLanguageDependentString("RemoteProcessVersionList.CreateVersionButton.Name.display"));
	buttonCreate.setFont(BPDConfig.getInstance().getFont());
	URL u = ResourceManager.getResource("CreateVersionImage");
	if (u != null) {
	    buttonCreate.setIcon(new ImageIcon(u));
	}
	// 为新建版本按钮添加侦听器
	buttonCreate.addActionListener(new ActionListener() {

	    public void actionPerformed(ActionEvent ae) {
		// 创建流程的新版本
		createVersion();
		dispose();
	    }
	});
	// 创建激活按钮
	buttonActivate = new JButton(ResourceManager.getLanguageDependentString("RemoteProcessVersionList.ActivateVersionButton.Name.display"));
	buttonActivate.setFont(BPDConfig.getInstance().getFont());
	u = ResourceManager.getResource("ActivateVersionImage");
	if (u != null) {
	    buttonActivate.setIcon(new ImageIcon(u));
	}
	// 为激活按钮添加侦听器
	buttonActivate.addActionListener(new ActionListener() {

	    public void actionPerformed(ActionEvent ae) {
		activateVersion();
	    }
	});
	// 创建冻结按钮
	buttonFreeze = new JButton(ResourceManager.getLanguageDependentString("RemoteProcessVersionList.FreezeVersionButton.Name.display"));
	buttonFreeze.setFont(BPDConfig.getInstance().getFont());
	u = ResourceManager.getResource("FreezeVersionImage");
	if (u != null) {
	    buttonFreeze.setIcon(new ImageIcon(u));
	}
	// 为激活按钮添加侦听器
	buttonFreeze.addActionListener(new ActionListener() {

	    public void actionPerformed(ActionEvent ae) {
		freezeVersion();
	    }
	});

	// 在按钮之间加空格
	versionButtonGroupPanel.add(buttonCreate);
	// 在按钮之间加空格
	versionButtonGroupPanel.add(Box.createVerticalStrut(10));
	versionButtonGroupPanel.add(buttonActivate);
	// 在按钮之间加空格
	versionButtonGroupPanel.add(Box.createVerticalStrut(10));
	versionButtonGroupPanel.add(buttonFreeze);
	versionButtonGroupPanel.add(Box.createVerticalStrut(80));
	return versionButtonGroupPanel;
    }

    /**
     * 显示或隐藏工作流版本列表
     */
    private void showAdvancePanel() {
	if (isShowAdvance) {
	    // 隐藏工作流版本列表
	    contentPanel.remove(subMainPanel);
	} else {
	    // 创建显示的主面板
	    subMainPanel = new JPanel();
	    subMainPanel.setLayout(new BoxLayout(subMainPanel, BoxLayout.X_AXIS));
	    subMainPanel.setAlignmentX(JPanel.CENTER_ALIGNMENT);
	    subMainPanel.add(createVersionListPanel());
	    subMainPanel.add(createVersionButtonGroupPanel());
	    contentPanel.add(new JSeparator(JSeparator.HORIZONTAL), BorderLayout.CENTER);
	    contentPanel.add(subMainPanel, BorderLayout.SOUTH);
	}
	// 重新显示JDialog面板
	this.pack();
	// 重置显示标志位
	isShowAdvance = !isShowAdvance;
    }

    /**
     * 创建面板侦听器
     */
    private WindowListener wl = new WindowAdapter() {

	public void windowClosing(WindowEvent e) {
	    dispose();
	}
    };

    /**
     * 获得所选流程的版本列表
     * 
     * @param selectedIndex
     *            流程集合的索引号
     * @return versionModel
     */
    private JList getVersionListModelOfSelProcess(int selectedIndex) {
	// 将选择流程的所有版本集添加到列表
	JList versionJList = new JList();
	DefaultListModel versionJListModel = new DefaultListModel();
	int selIndex = 0;

	ProcessDef processDef = processInfoList.get(selectedIndex);

	try {
	    versionInfoList = processDef.getAllProcessDefVersions();
	} catch (BPMException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	}
	if (versionInfoList != null && versionInfoList.size() != 0) {
	    for (int i = 0; i < versionInfoList.size(); i++) {
		ProcessDefVersion processDefVersion = (ProcessDefVersion) versionInfoList.get(i);
		String versionName = Integer.valueOf(processDefVersion.getVersion()).toString();
		if (processDefVersion.getPublicationStatus().equals(ProcessDefVersionStatus.RELEASED)) {
		    selIndex = i;
		}
		versionJListModel.addElement("(" + processDefVersion.getPublicationStatus().getName() + ")");
	    }
	    // 设置流程版本列表的鼠标提示
	    String versionDescription = ((ProcessDefVersion) versionInfoList.get(selIndex)).getDescription();
	    versionJList.setToolTipText(versionDescription);
	}

	versionJList.setModel(versionJListModel);
	versionJList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	// 设置流程版本列表的默认选项
	versionJList.setSelectedIndex(selIndex);
	return versionJList;
    }

    /**
     * 删除选择的远端流程
     */
    private void deleteRemoteWorkflowProcesses() {
	int dialogFlag;
	String versionIdsString = "";
	ProcessDefVersion processDefVersion;
	if (processJList.getSelectedIndex() == -1) {
	    return;
	}
	if (!isShowAdvance) {
	    // 删除整个流程，包括所有版本
	    dialogFlag = JOptionPane.showConfirmDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("MessageIsDeleteProcessDef"), BPD.getAppTitle(), JOptionPane.YES_NO_OPTION);
	    if (dialogFlag == JOptionPane.NO_OPTION) {
		return;
	    } else {
		// 如果没有显示高级选项，就直接删除流程所有版本

		int selectedIndex = processJList.getSelectedIndex();
		ProcessDef processDef = processInfoList.get(selectedIndex);

		try {
		    versionInfoList = processDef.getAllProcessDefVersions();
		} catch (BPMException e) {
		    // TODO Auto-generated catch block
		    e.printStackTrace();
		}
		for (int i = 0; i < versionInfoList.size(); i++) {
		    // 获得版本ID字符串，以逗号分割
		    processDefVersion = (ProcessDefVersion) versionInfoList.get(i);
		    if (i != 0) {
			versionIdsString += ",";
		    }
		    versionIdsString += processDefVersion.getProcessDefVersionId();
		}
		// 删除所选项后，刷新版本面板
		DefaultListModel listModel = (DefaultListModel) processJList.getModel();
		listModel.removeElementAt(selectedIndex);
		processJList.setSelectedIndex(processJList.getFirstVisibleIndex());
	    }

	} else {
	    // 删除选择的流程版本
	    dialogFlag = JOptionPane.showConfirmDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("MessageIsDeleteProcessDefVersion"), BPD.getAppTitle(), JOptionPane.YES_NO_OPTION);
	    if (dialogFlag == JOptionPane.NO_OPTION) {
		return;
	    } else {
		if (versionInfoList != null && versionInfoList.size() != 0) {
		    int selectedIndex = versionJList.getSelectedIndex();
		    processDefVersion = (ProcessDefVersion) versionInfoList.get(selectedIndex);
		    versionIdsString = processDefVersion.getProcessDefVersionId();
		    // 删除所选项后，刷新版本面板
		    DefaultListModel versionListModel = (DefaultListModel) versionJList.getModel();
		    versionListModel.removeElementAt(selectedIndex);
		    versionInfoList.remove(selectedIndex);
		    if (versionListModel.size() == 0) {
			DefaultListModel processListModel = (DefaultListModel) processJList.getModel();
			processListModel.remove(processJList.getSelectedIndex());
		    } else {
			versionJList.setSelectedIndex(versionJList.getFirstVisibleIndex());
		    }
		}
	    }
	}
	if (!versionIdsString.equals("")) {
	    // 从WebService服务器删除选择的流程或流程版本

	    boolean deleteSuccessFlag = false;
	    try {

		deleteSuccessFlag = BPD.getInstance().getBPDService().deleteProcessDefListToDB(versionIdsString);

		// 删除操作成功
		if (deleteSuccessFlag) {
		    // 从远端服务器后，缓存重新获得远程流程定义列表
		    BPD.getInstance().setRemoteProcessMap(BPD.getInstance().getRemoteProcessDefList(true));
		    // 刷新流程树列表
		    MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getRemotePackageTreePanel().refreshPackageTreePanel();
		    JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("MessageDeleteProcessDefVersionSuccess"), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
		}
	    } catch (JDSException e) {
		BPD.getInstance().getBPDService().handleWebServiceException(e);
	    }
	}
	// 刷新界面
	BPD.getInstance().getPackageEditor().valueChanged(null);
    }

    /**
     * 创建选择流程的新版本
     */
    private void createVersion() {
	// 获得当前选择的流程对象
	ProcessDef processDef = processInfoList.get(processJList.getSelectedIndex());

	if (processDef != null) {
	    // 设置流程新版本的初始值
	    int maxVersionId = 0;
	    // 获得当前流程的最大版本号和最大版本号的流程信息
	    List<ProcessDefVersion> versionInfoList = new ArrayList<ProcessDefVersion>();
	    try {
		versionInfoList = processDef.getAllProcessDefVersions();
	    } catch (BPMException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	    }

	    for (ProcessDefVersion processDefVersion : versionInfoList) {

		int version = processDefVersion.getVersion();
		if (version > maxVersionId) {
		    maxVersionId = version;
		    maxVersion = Integer.valueOf(processDefVersion.getVersion()).toString();
		    this.remoteVersionId = processDefVersion.getProcessDefVersionId();
		}
	    }

	    // 从服务器获取流程的进程
	    task = new CreateVersionTask();
	    dispose();
	    SwingUtilities.invokeLater(new Runnable() {
		public void run() {
		    String progressTitle = ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Title.Name.display");
		    String progressDescription = ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Description.Name.display");
		    String progressMessage = ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Message.Name.display");
		    ProgressDialog progressDialog = new ProgressDialog((JFrame) getParent(), progressTitle, progressDescription, progressMessage, task, 0, false);
		    progressDialog.dispose();
		}
	    });
	    task.go();
	}
    }

    /**
     * 激活选择流程版本
     */
    private void activateVersion() {
	int dialogFlag;
	String versionId = "";
	// 激活选择的流程版本
	dialogFlag = JOptionPane.showConfirmDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("MessageIsActivateProcessDefVersion"), BPD.getAppTitle(), JOptionPane.YES_NO_OPTION);
	if (dialogFlag == JOptionPane.NO_OPTION) {
	    return;
	} else {
	    if (versionInfoList != null && versionInfoList.size() != 0) {
		int selectedIndex = versionJList.getSelectedIndex();
		ProcessDefVersion selProcessDefVersion = (ProcessDefVersion) versionInfoList.get(selectedIndex);
		// 选择了已经激活的版本
		if (selProcessDefVersion.getPublicationStatus().equals(ProcessDefVersionStatus.RELEASED)) {
		    return;
		}
		versionId = selProcessDefVersion.getProcessDefVersionId();
		if (!versionId.equals("")) {
		    // 从WebService服务器激活选择的流程版本

		    boolean activateSuccessFlag = false;
		    try {
			activateSuccessFlag = BPD.getInstance().getBPDService().activateProcessDefVersion(versionId);
			// 激活操作成功
			if (activateSuccessFlag) {
			    // 重新获得流程信息
			    processInfoList = BPD.getInstance().getRemoteProcessDefList(true);
			    versionJList = getVersionListModelOfSelProcess(processJList.getSelectedIndex());
			    // 刷新流程列表
			    refreshVersionJList(versionJList);
			    BPD.getInstance().setRemoteProcessMap(processInfoList);
			    // 刷新已经打开的流程
			    BPD.getInstance().refreshOpenedWorkflowProcess();
			    // 刷新流程树列表
			    MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getRemotePackageTreePanel().refreshPackageTreePanel();
			    BPD.getInstance().getPackageEditor().valueChanged(null);

			    // 激活成功标志
			    JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("MessageActivateProcessDefVersionSuccess"), BPD.getAppTitle(),
				    JOptionPane.WARNING_MESSAGE);
			}
		    } catch (JDSException e) {
			BPD.getInstance().getBPDService().handleWebServiceException(e);
		    }
		}
	    }
	}
    }

    /**
     * 冻结选择流程版本
     */
    private void freezeVersion() {
	int dialogFlag;
	String versionId = "";
	// 冻结选择的流程版本
	dialogFlag = JOptionPane.showConfirmDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("MessageIsFreezeProcessDefVersion"), BPD.getAppTitle(), JOptionPane.YES_NO_OPTION);
	if (dialogFlag == JOptionPane.NO_OPTION) {
	    return;
	} else {
	    if (versionInfoList != null && versionInfoList.size() != 0) {
		int selectedIndex = versionJList.getSelectedIndex();
		ProcessDefVersion selProcessDefVersion = (ProcessDefVersion) versionInfoList.get(selectedIndex);
		// 选择了已经冻结的版本
		if (!selProcessDefVersion.getPublicationStatus().equals(ProcessDefVersionStatus.RELEASED)) {
		    return;
		}
		versionId = selProcessDefVersion.getProcessDefVersionId();
		if (!versionId.equals("")) {
		    // 从WebService服务器冻结选择的流程版本

		    boolean freezeSuccessFlag = false;
		    try {
			freezeSuccessFlag = BPD.getInstance().getBPDService().freezeProcessDefVersion(versionId);
			// 冻结操作成功
			if (freezeSuccessFlag) {
			    // 重新获得流程信息
			    processInfoList = BPD.getInstance().getRemoteProcessDefList(true);
			    versionJList = getVersionListModelOfSelProcess(processJList.getSelectedIndex());
			    // 刷新流程列表
			    refreshVersionJList(versionJList);
			    BPD.getInstance().setRemoteProcessMap(processInfoList);
			    // 刷新已经打开的流程
			    BPD.getInstance().refreshOpenedWorkflowProcess();
			    // 刷新流程树列表
			    MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getRemotePackageTreePanel().refreshPackageTreePanel();
			    BPD.getInstance().getPackageEditor().valueChanged(null);

			    // 冻结成功标志
			    JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(), ResourceManager.getLanguageDependentString("MessageFreezeProcessDefVersionSuccess"), BPD.getAppTitle(),
				    JOptionPane.WARNING_MESSAGE);
			}
		    } catch (JDSException e) {
			BPD.getInstance().getBPDService().handleWebServiceException(e);
		    }
		}
	    }
	}
    }

    /**
     * 刷新流程版本列表面板
     * 
     * @param selectedIndex
     *            流程列表中当前选择的流程索引
     */
    private void refreshVersionJList(JList versionJList) {
	JScrollPane scrollVersionList = (JScrollPane) versionJListPanel.getComponent(3);
	scrollVersionList.setViewportView(versionJList);
	this.pack();
    }

    class OpenProcessTask extends Task {

	public OpenProcessTask() {
	    setLengthOfTask(10);
	}

	/*
	 * 获得流程列表
	 * 
	 * @see com.ds.common.swing.progress.Task#go()
	 */
	public void go() {
	    final SwingWorker worker = new SwingWorker() {

		public Object construct() {
		    try {
			setMessage(ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Message.GetProcessInfo.Name.display"));

			String xpdlString = BPD.getInstance().getPackProcessDefList(remoteVersionId);
			setMessage(ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Message.OpenProcess.Name.display"));

			// 打开选择的流程
			BPD.getInstance().openWFFromString(xpdlString);
		    } catch (Exception e) {
			stop();
			// e.printStackTrace();
			return new Object();
		    } finally {
			stop();
		    }
		    return new Object();
		}
	    };
	    worker.start();
	}

	/*
	 * @see com.ds.common.swing.progress.Task#cancel()
	 */
	public void cancel() {
	}

	/*
	 * @see com.ds.common.swing.progress.Task#complete()
	 */
	public void complete() {
	}
    }

    // 创建流程新版本Task
    class CreateVersionTask extends Task {

	public CreateVersionTask() {
	    setLengthOfTask(10);
	}

	/*
	 * 创建流程新版本
	 * 
	 * @see com.ds.common.swing.progress.Task#go()
	 */
	public void go() {
	    final SwingWorker worker = new SwingWorker() {

		public Object construct() {
		    try {
			setMessage(ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Message.GetProcessInfo.Name.display"));

			String xpdlString = BPD.getInstance().getPackProcessDefList(remoteVersionId);
			setMessage(ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Message.CreateVersion.Name.display"));
			BPD.getInstance().cloneWorkflowProcess(xpdlString);
			int selectedIndex = processJList.getSelectedIndex();
			// 获得版本列表JList对象
			versionJList = getVersionListModelOfSelProcess(selectedIndex);
			// 重新刷新版本列表
			refreshVersionJList(versionJList);
		    } catch (Exception e) {
			stop();
			// e.printStackTrace();
			return new Object();
		    } finally {
			stop();
		    }
		    return new Object();
		}
	    };
	    worker.start();
	}

	/*
	 * @see com.ds.common.swing.progress.Task#cancel()
	 */
	public void cancel() {
	}

	/*
	 * @see com.ds.common.swing.progress.Task#complete()
	 */
	public void complete() {
	}
    }
}
