
package com.ds.bpm.bpd.plugin.impl.route;

import com.ds.bpm.bpd.plugin.ExpressionElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.plugin.impl.activity.Message;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.Transition;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.formula.Formulas;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.config.BPDPlugin;
import com.ds.config.CFormula;
import com.ds.esb.config.formula.FormulaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.*;

public class RouteFormulaPlugin extends ExpressionElement {

    List<Formulas> formulas = new ArrayList<>();

    Map<String, List<ExtendedAttribute>> formulaMap=new HashMap<>();


    public List<Formulas> getFormulas() {
        return formulas;
    }

    public void setFormulas(List<Formulas> formulas) {
        this.formulas = formulas;
    }

    public RouteFormulaPlugin(BPDPlugin bpdElement) {
        super(bpdElement);
        Map<String, CFormula> map = this.getBpdElement().getFormulaTypeMap();
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            CFormula cformula = map.get(key);
            Formulas formula = new Formulas(this,key, cformula.getParameterValue());
            formula.setLabelName(cformula.getDesc());
            formulas.add(formula);

        }
        fillStructure();
    }

    public WorkflowProcess getProcess() {
        return wp;
    }

    protected void fillStructure() {
        for (Formulas formula : formulas) {
            complexStructure.add(formula);
        }
        super.fillStructure();
    }

    // 把活动办理权限信息保存在XML文件中
    public void toXML(Node parent) {
        NodeList nodeList = ((Element) parent).getElementsByTagName("ExtendedAttributes");
        Element easElem;
        Document doc = parent.getOwnerDocument();
        if (nodeList.getLength() != 0) {
            easElem = (Element) nodeList.item(0);
        } else {
            easElem = doc.createElement("ExtendedAttributes");
            parent.appendChild(easElem);
        }

        for (Iterator iter = complexStructure.iterator(); iter.hasNext(); ) {
            XMLElement element = (XMLElement) iter.next();
            if (element instanceof Formulas) {
                element.toXML(easElem);
            } else {
                Element eaElem = doc.createElement("ExtendedAttribute");
                eaElem.setAttribute("Name", element.toName());
                eaElem.setAttribute("Value", element.toValue().toString());
                eaElem.setAttribute("Type", FormulaType.ESDCOM.getBaseType().getType());
                easElem.appendChild(eaElem);
            }
        }

    }


    public XMLAttribute getXMLAttributeByName(String name) {

        Iterator it = complexStructure.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof XMLAttribute) {
                XMLAttribute att = (XMLAttribute) obj;
                if (name.equalsIgnoreCase(att.toKey().toString())) {
                    return att;
                }
            }
        }

        return null;

    }

    // 从活动扩展属性保存到活动权限对象
    public void afterImporting() throws PluginException {
        Object obj = getProperty("Route");
        if (obj == null) {
            throw new PluginException(Message.getLanguageDependentString("Plugin.Initialize.Error"));
        }
        route = (Transition) obj;
        ExtendedAttributes exAttrs = (ExtendedAttributes) route.get("ExtendedAttributes");
        Set easToRemove = new HashSet();
        Iterator it = exAttrs.toCollection().iterator();
        String nm = "";
        String val = "";


        for (Formulas cformula : formulas) {
            formulaMap.put(cformula.getFormulaName(),new ArrayList<ExtendedAttribute>());
        }




        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute) it.next();
            nm = ea.get("Name").toValue().toString();
            val = ea.get("Value").toValue().toString();

            for (Formulas formula : formulas) {
                nm.startsWith(formula.getFormulaName());
                List<ExtendedAttribute> formulas=   formulaMap.get(formula.getFormulaName());
                formulas.add(ea);
                continue;
            }

            XMLAttribute attribute = this.getXMLAttributeByName(nm);
            if (attribute != null) {
                attribute.setValue(val);
                attribute.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }

        }

        for (Formulas formula : formulas) {
            List<ExtendedAttribute> formulas=   formulaMap.get(formula.getFormulaName());
            formula.afterImporting(formulas);
        }

        exAttrs.toCollection().removeAll(easToRemove);
    }

    public void setLabelName() {
        // 初始化页面显示属性
        setLabelName(this.getBpdElement().getDisplayname());
    }

    public Object clone() {
        RouteFormulaPlugin ar = (RouteFormulaPlugin) super.clone();
        List<Formulas> formulasList=new ArrayList<>();
        for (Formulas formula : formulas) {
            formulasList.add((Formulas) formula.clone());
        }
        ar.setFormulas(formulasList);
        ar.fillStructure();
        return ar;
    }

    public XMLPanel getPanel() {

        List<XMLPanel> panels=new ArrayList<>();
        for (Formulas formula : formulas) {
            panels.add(formula.getPanel());
        }

        return new XMLTabbedPanel(this, panels.toArray(new XMLPanel[]{}));
    }
}
