
package com.ds.bpm.bpd.plugin.impl.process;

import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.formula.Formulas;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.bpm.enums.form.FormNameEnum;
import com.ds.bpm.enums.process.FormRightEnums;
import com.ds.common.util.XMLUtility;
import com.ds.config.BPDPlugin;
import com.ds.enums.CommonYesNoEnum;
import com.ds.enums.EnumsUtil;
import com.ds.enums.attribute.Attributetype;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import java.util.*;

public class ProcessFormPlugin extends PluginElement {


    private XMLAttribute markType = new XMLAttribute(EnumsUtil.getAttribute(FormRightEnums.Mark));

    private XMLAttribute noSql = new XMLAttribute(EnumsUtil.getAttribute(FormRightEnums.NoSql));

    private XMLAttribute lockTypoe = new XMLAttribute(EnumsUtil.getAttribute(FormRightEnums.Lock));

    private XMLAttribute autoSave = new XMLAttribute(EnumsUtil.getAttribute(FormRightEnums.AutoSave));

    private Forms forms;

    private Tables tables;

    public ProcessFormPlugin(BPDPlugin plugin) {
        super(plugin);
        setLabelName(plugin.getDisplayname() == null ? "动态表单" : plugin.getDisplayname());
        forms = new Forms(this);
        tables = new Tables(this);
        fillStructure();
    }


    protected void fillStructure() {
        super.fillStructure();
        noSql.setValue(CommonYesNoEnum.NO.getType());
        autoSave.setValue(CommonYesNoEnum.YES.getType());
        complexStructure.add(markType);
        complexStructure.add(noSql);
        complexStructure.add(lockTypoe);
        complexStructure.add(autoSave);
    }

    public void toXML(Node parent) {
        Element easElem = (Element) XMLUtility.getFirstChild(parent,
                "ExtendedAttributes");
        Document doc = parent.getOwnerDocument();
        if (easElem == null) {
            easElem = doc.createElement("ExtendedAttributes");
            parent.appendChild(easElem);
        }

        for (Iterator iter = complexStructure.iterator(); iter.hasNext(); ) {
            XMLElement element = (XMLElement) iter.next();
            if (element instanceof Formulas || element instanceof Forms) {
                element.toXML(easElem);
            } else {
                Element eaElem = doc.createElement("ExtendedAttribute");
                eaElem.setAttribute("Name", element.toName());
                eaElem.setAttribute("Value", element.toValue().toString());
                eaElem.setAttribute("Type", Attributetype.PAGE.getType());
                easElem.appendChild(eaElem);
            }
        }
        tables.toXML(easElem);
        forms.toXML(easElem);
    }


    public XMLAttribute getXMLAttributeByName(String name) {

        Iterator it = complexStructure.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof XMLAttribute) {
                XMLAttribute att = (XMLAttribute) obj;
                if (name.equalsIgnoreCase(att.toName())) {
                    return att;
                }
            }
        }

        return null;

    }

    // 从活动扩展属性保存到活动权限对象
    public void afterImporting() throws PluginException {
        Object wpObj = getProperty("WorkflowProcess");
        if (wpObj == null) {
            throw new PluginException(Message.getLanguageDependentString("Plugin.Initialize.Error"));
        }
        WorkflowProcess wf = (WorkflowProcess) wpObj;
        ExtendedAttributes exAttrs = (ExtendedAttributes) wf.get("ExtendedAttributes");
        Set easToRemove = new HashSet();
        Iterator it = exAttrs.toCollection().iterator();
        String nm = "";
        String val = "";
        //  List commandSelectedList = new ArrayList();
        List wpForms = new ArrayList();
        List wpTables = new ArrayList();
        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute) it.next();
            nm = ea.get("Name").toValue().toString();
            val = ea.get("Value").toValue().toString();

            if (nm.startsWith(Attributetype.PAGE.getType()) || nm.equals(Attributetype.DB.getType())) {
                easToRemove.add(ea);
                continue;
            }

            if (nm.startsWith(FormNameEnum.FORM.getType())) {
                easToRemove.add(ea);
                if (!nm.equalsIgnoreCase(FormNameEnum.FORM.getType())) {
                    wpForms.add(ea);
                }
            }

            if (nm.startsWith(FormNameEnum.TABLE.getType())) {
                easToRemove.add(ea);
                if (!nm.equalsIgnoreCase(FormNameEnum.TABLE.getType())) {
                    wpTables.add(ea);
                }
            }

            XMLAttribute attribute = this.getXMLAttributeByName(nm);
            if (attribute != null) {
                attribute.setValue(val);
                attribute.refreshDisplayValue();
                easToRemove.add(ea);
                continue;
            }
        }

        exAttrs.toCollection().removeAll(easToRemove);

        ((Forms) forms).afterImporting(wpForms);
        ((Tables) tables).afterImporting(wpTables);
    }

    public void setLabelName() {
        // 初始化页面显示属性
        setLabelName(this.getBpdElement().getDisplayname());
    }

    public Object clone() {
        ProcessFormPlugin ar = (ProcessFormPlugin) super.clone();
        ar.markType = (XMLAttribute) this.markType.clone();
        ar.noSql = (XMLAttribute) this.noSql.clone();
        ar.lockTypoe = (XMLAttribute) this.lockTypoe.clone();
        ar.autoSave = (XMLAttribute) this.autoSave.clone();
        ar.tables = this.tables.clone();
        ar.forms = this.forms.clone();
        ar.fillStructure();
        return ar;
    }

    public XMLPanel getPanel() {
        XMLPanel commonPanel = new XMLGroupPanel(this, complexStructure.toArray(), "存储规则");
        return new XMLTabbedPanel(this, new XMLPanel[]{commonPanel, forms.getPanel(), tables.getPanel()});
    }
}
