/*
 * Created on 2004-2-23
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.process;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.common.JDSException;
import com.ds.common.database.metadata.TableInfo;
import com.ds.common.util.XMLUtility;
import com.ds.config.BPDPlugin;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.iot.json.UserInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProcessForm extends PluginElement {


    public static final String FORM_NAME = "FORM";


    public static final String TYPE_NAME = "APPLICATION";

    private XMLElement forms;

    private WorkflowProcess wp;




    public ProcessForm(BPDPlugin plugin) {
        super(plugin);
        forms = new Forms(this);

        setLabelName(Message
                .getLanguageDependentString("Process.ProcessForm.display"));
        fillStructure();

    }

    protected void fillStructure() {
        super.fillStructure();
        complexStructure.add(forms);
    }


    public void toXML(Node parent) {
        Element easElem = (Element) XMLUtility.getFirstChild(parent,
                "ExtendedAttributes");
        Document doc = parent.getOwnerDocument();
        if (easElem == null) {
            easElem = doc.createElement("ExtendedAttributes");
            parent.appendChild(easElem);
        }
        for (Iterator iter = complexStructure.iterator(); iter.hasNext(); ) {
            XMLElement element = (XMLElement) iter.next();
            element.toXML(easElem);
        }
    }


    public String[][] getForms() {
        String[][] forms = null;
        UserInfo user = BPD.getInstance().getUserInfo();
        if (user != null) {
            try {
                Project project = ESDFacrory.getESDClient().getProjectByName(wp.getProjectName());
                List<TableInfo> tableInfos = project.getTables();
                forms = new String[tableInfos.size()][3];
                int k = 0;
                for (TableInfo tableInfo : tableInfos) {
                    forms[k][0] = Utils.filterNull(tableInfo.getCnname() + "[" + tableInfo.getName() + "]");
                    forms[k][1] = Utils.filterNull(tableInfo.getName());
                    forms[k][2] = Utils.filterNull(tableInfo.getName());
                    k = k + 1;
                }
            } catch (JDSException e) {
                e.printStackTrace();
            }
        }
         return forms;
    }

    public void afterImporting() throws PluginException {
        Object obj = getProperty("Process");
        if (obj == null) {
            throw new PluginException(Message
                    .getLanguageDependentString("Plugin.Initialize.Error"));
        }
        wp = (WorkflowProcess) obj;
        ExtendedAttributes exAttrs = (ExtendedAttributes) wp
                .get("ExtendedAttributes");
        Set easToRemove = new HashSet();
        Iterator it = exAttrs.toCollection().iterator();
        String nm = "";
        String val = "";
        List wpForms = new ArrayList();
        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute) it.next();
            nm = ea.get("Name").toValue().toString();
            val = ea.get("Value").toValue().toString();
            if (nm.startsWith(ProcessForm.FORM_NAME)) {
                easToRemove.add(ea);
                if (!nm.equalsIgnoreCase(ProcessForm.FORM_NAME)) {
                    wpForms.add(ea);
                }
            }
        }
        exAttrs.toCollection().removeAll(easToRemove);
        ((Forms) forms).afterImporting(wpForms);
    }

    public Object clone() {
        ProcessForm pf = (ProcessForm) super.clone();
        pf.forms = (XMLElement) this.forms.clone();
        pf.fillStructure();
        return pf;
    }
}
