/*
 * Created on 2004-2-25
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.process;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.ds.config.BPDPlugin;
import com.ds.esb.config.formula.FormulaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ds.bpm.bpd.plugin.ExpressionElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.formula.Formulas;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;

/**
 * <p>
 * Title: ISD设计工具（BPD）
 * </p>
 * <p>
 * Description: 流程启动条件
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author 文章 2018-1-5 14:13:32
 * @version 3.0
 */
public class ProcessDeviceEvent extends ExpressionElement {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Formulas performSelected = new Formulas(this, FormulaType.DeviceSelectedID);

	//	

	private XMLAttribute eventType = new XMLAttribute("DeviceEvent",
			new Object[] { new String[] { "传感器数据上报", "dataReport" },
					new String[] { "传感器上线", "sensorOnLine" },
					new String[] { "传感器离线", "sensorOffLine" },
					new String[] { "报警信息", "alarmReport" },
					new String[] { "网关注册", "register" },
					new String[] { "绑定报告", "bindListReport" },
					new String[] { "模式上报", "modeListReport" },
					new String[] { "登录", "login" },
					new String[] { "退出", "logout" },
					new String[] { "发现新传感器", "findSensor" },
					new String[] { "修改WIFI", "changeNetworkResponse" },
					new String[] { "传感器上报", "sensorReport" },
					new String[] { "绑定状态报告", "bindingStatusReport" },
					new String[] { "命令报告", "commandReport" },
					new String[] { "网关离线", "gatewayOffLine" },
					new String[] { "网关上线", "gatewayOnLine" },
					new String[] { "网关错误报告", "gatewayErrorReport" }, }, 0);

	private XMLAttribute gwEventType = new XMLAttribute("DeviceEvent",
			new Object[] { new String[] { "传感器数据上报", "dataReport" },
					new String[] { "传感器上线", "sensorOnLine" },
					new String[] { "传感器离线", "sensorOffLine" },
					new String[] { "报警信息", "alarmReport" },
					new String[] { "网关注册", "register" },
					new String[] { "绑定报告", "bindListReport" },
					new String[] { "模式上报", "modeListReport" },
					new String[] { "登录", "login" },
					new String[] { "退出", "logout" },
					new String[] { "发现新传感器", "findSensor" },
					new String[] { "修改WIFI", "changeNetworkResponse" },
					new String[] { "传感器上报", "sensorReport" },
					new String[] { "绑定状态报告", "bindingStatusReport" },
					new String[] { "命令报告", "commandReport" },
					new String[] { "网关离线", "gatewayOffLine" },
					new String[] { "网关上线", "gatewayOnLine" },
					new String[] { "网关错误报告", "gatewayErrorReport" }, }, 0);

	private XMLAttribute sensorEventType = new XMLAttribute("DeviceEvent",
			new Object[] { new String[] { "传感器数据上报", "dataReport" },
					new String[] { "传感器上线", "sensorOnLine" },
					new String[] { "传感器离线", "sensorOffLine" },
					new String[] { "发现新传感器", "findSensor" },
					new String[] { "修改WIFI", "changeNetworkResponse" },
					new String[] { "传感器上报", "sensorReport" },

			}, 0);

	private XMLAttribute accountEventType = new XMLAttribute("DeviceEvent",
			new Object[] {

			new String[] { "登录", "login" }, new String[] { "退出", "logout" },

			new String[] { "网关离线", "gatewayOffLine" },
					new String[] { "网关上线", "gatewayOnLine" },
					new String[] { "网关错误报告", "gatewayErrorReport" }, }, 0);

	public ProcessDeviceEvent(BPDPlugin plugin) {
		super(plugin);
		fillStructure();
	}

	protected void fillStructure() {
		super.fillStructure();
		complexStructure.add(eventType);
		complexStructure.add(performSelected);

	}

	// 把活动办理权限信息保存在XML文件中
	public void toXML(Node parent) {
		NodeList nodeList = ((Element) parent)
				.getElementsByTagName("ExtendedAttributes");
		Element easElem;
		Document doc = parent.getOwnerDocument();
		if (nodeList.getLength() != 0) {
			easElem = (Element) nodeList.item(0);
		} else {
			easElem = doc.createElement("ExtendedAttributes");
			parent.appendChild(easElem);
		}
		for (Iterator iter = complexStructure.iterator(); iter.hasNext();) {
			XMLElement element = (XMLElement) iter.next();
			if (element instanceof Formulas) {
				element.toXML(easElem);
			} else {
				Element eaElem = doc.createElement("ExtendedAttribute");
				eaElem.setAttribute("Type", "DeviceEvent");
				eaElem.setAttribute("Name", element.toName());
				eaElem.setAttribute("Value", element.toValue().toString());
				easElem.appendChild(eaElem);
			}
		}

	}

	// 从活动扩展属性保存到活动权限对象
	public void afterImporting() throws PluginException {
		Object obj = getProperty("Process");
		if (obj == null) {
			throw new PluginException(Message
					.getLanguageDependentString("Plugin.Initialize.Error"));
		}
		act = (Activity) obj;
		ExtendedAttributes exAttrs = (ExtendedAttributes) act
				.get("ExtendedAttributes");
		Set easToRemove = new HashSet();
		Iterator it = exAttrs.toCollection().iterator();
		String nm = "";
		String val = "";
		List performerSelectedList = new ArrayList();

		while (it.hasNext()) {
			ExtendedAttribute ea = (ExtendedAttribute) it.next();
			nm = ea.get("Name").toValue().toString();
			val = ea.get("Value").toValue().toString();
			if (nm.startsWith("DEVICESELECTEDID".toUpperCase())) {
				performerSelectedList.add(ea);
				easToRemove.add(ea);
				continue;
			}

			if (nm.equalsIgnoreCase("DeviceEvent")) {
				eventType.setValue(val);
				//		
				// eventType.refreshDisplayValue();
				// eventType.refreshPanelValue();
				easToRemove.add(ea);
				continue;
			}

		}

		performSelected.afterImporting(performerSelectedList);

		exAttrs.toCollection().removeAll(easToRemove);
	}

	public void setLabelName() {
		// 初始化页面显示属性
		setLabelName(Message
				.getLanguageDependentString("Process.DeviceEvent.display"));
		eventType
				.setLabelName(Message
						.getLanguageDependentString("Process.DeviceEvent.EventSelected.display"));

		eventType
				.setLabelName(Message
						.getLanguageDependentString("Process.DeviceEvent.EventSelected.display"));
		performSelected
				.setLabelName(Message
						.getLanguageDependentString("Process.DeviceEvent.PerformType.display"));

	}

	public Object clone() {
		ProcessDeviceEvent ar = (ProcessDeviceEvent) super.clone();
		ar.eventType = (XMLAttribute) this.eventType.clone();
		ar.performSelected = (Formulas) this.performSelected.clone();

		ar.fillStructure();
		return ar;
	}

	public XMLPanel getPanel() {

		XMLPanel commonPanel = new XMLGroupPanel(this, new XMLElement[] {
				eventType, performSelected }, Message
				.getLanguageDependentString("Process.Device.Common.display"));

		return new XMLTabbedPanel(this, new XMLPanel[] { commonPanel });
	}
}
