/*
 * Created on 2004-2-23
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.process;


import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.xml.*;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.panels.XMLComboPanel;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.enums.form.FormNameEnum;
import com.ds.common.JDSException;
import com.ds.common.util.StringUtility;
import com.ds.enums.attribute.Attributetype;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.tool.module.EUModule;
import com.ds.esd.tool.module.EUPackage;
import com.ds.iot.json.UserInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import java.util.HashSet;
import java.util.Set;

public class Form extends XMLCollectionElement {


    private XMLElement attrName = new XMLAttribute("Value");
    private XMLAttribute attrDesc = new XMLAttribute("Description");

    private XMLElement form;

    String[][] chooseForms;

    public Form(XMLCollection myCollection) {
        super(myCollection);
        setLabelName(Message
                .getLanguageDependentString("Process.ProcessForm.MainForm.display"));

        attrId
                .setLabelName(Message
                        .getLanguageDependentString("Process.ProcessForm.MainForm.ID.display"));

        attrName
                .setLabelName("名称");

        attrDesc
                .setLabelName("用途");
        fillStructure();
    }

    protected void fillStructure() {
        super.fillStructure();
        complexStructure.add(attrName);
        attributes.add(attrName);
        complexStructure.add(attrDesc);
        attributes.add(attrDesc);
    }

    public String[][] getForms() {

        Object wpObj = ((ProcessFormPlugin) getCollection().getOwner()).getProperty("WorkflowProcess");

        WorkflowProcess wp = (WorkflowProcess) wpObj;

        String[][] forms = null;
        UserInfo user = BPD.getInstance().getUserInfo();
        if (user != null) {
            try {
                Project project = ESDFacrory.getESDClient().getProjectByName(wp.getProjectName());
                EUPackage euPackage = project.getActiveProjectVersion().getPackageByPath("form");
                Set<EUModule> modules = new HashSet<>();
                if (euPackage != null) {
                    modules = euPackage.listModules();
                }
                forms = new String[modules.size()][3];
                int k = 0;
                for (EUModule module : modules) {
                    forms[k][0] = Utils.filterNull(module.getComponent().getTitle() == null ? module.getComponent().getAlias() : module.getComponent().getTitle());
                    forms[k][1] = Utils.filterNull(StringUtility.replace(module.getClassName(), ".", "_"));
                    forms[k][2] = Utils.filterNull(module.getClassName());
                    k = k + 1;
                }
            } catch (JDSException e) {
                e.printStackTrace();
            }
        }
        return forms;
    }

    public XMLPanel getPanel() {

        chooseForms = getForms();
        if (chooseForms != null) {
            form = new XMLComplexChoice(FormNameEnum.FORM.getType(), null, 0) {
                public XMLPanel getPanel() {
                    choices = chooseForms;
                    if (getChoosen() == null && choices != null
                            && choices.length > 0) {
                        XMLSelectOption obj;
                        if (!attrName.toValue().toString().equals("")
                                && !attrId.toValue().toString().equals("")) {
                            obj = new XMLSelectOption(attrName.toValue()
                                    .toString(), attrId.toValue().toString());
                        } else {
                            obj = new XMLSelectOption(
                                    ((String[]) choices[0])[0],
                                    ((String[]) choices[0])[1]);
                        }
                        super.setValue(obj);
                    }
                    return new XMLComboPanel(this, chooseForms);
                }

                public void setValue(Object v) {
                    if (choices != null && getChoosen() != null) {
                        super.setValue(v);
                        XMLSelectOption choose = (XMLSelectOption) getChoosen();
                        attrId.setValue(choose.getText());
                        attrName.setValue(choose.getName());
                        attrDesc.setValue(getValueFromArray(chooseForms, choose
                                .getText(), 2));
                    }
                }
            };
            form
                    .setLabelName(Message
                            .getLanguageDependentString("Process.ProcessForm.MainForm.Name.display"));
            return new XMLGroupPanel(this, new XMLElement[]{form});
        } else {
            return null;
        }
    }


    public Object clone() {
        Form f = (Form) super.clone();
        f.attrName = (XMLElement) this.attrName.clone();
        f.attrDesc = (XMLAttribute) this.attrDesc.clone();
        f.fillStructure();
        return f;
    }

    private String getValueFromArray(String[][] array, String id, int index) {
        String ret = "";
        for (int i = 0; i < array.length; i++) {
            String[] cell = array[i];
            if (index < 0 || index >= cell.length) {
                return "";
            }
            if (cell[1].equals(id)) {
                ret = cell[index];
                break;
            }
        }
        return ret;
    }

    public boolean hasForms() {
        return (chooseForms != null && chooseForms.length > 0);
    }

    public void toXML(Node parent) {
        Element elem = parent.getOwnerDocument().createElement(
                "ExtendedAttribute");
        elem.setAttribute("Name", FormNameEnum.FORM.getType() + "."
                + attrId.toValue().toString());
        elem.setAttribute("Type", Attributetype.PAGE.getType());
        elem.setAttribute("Value", attrName.toValue().toString() + ";"
                + attrDesc.toValue().toString());
        parent.appendChild(elem);
    }

    public void afterImporting(Object obj) {
        if (obj instanceof ExtendedAttribute) {
            ExtendedAttribute ea = (ExtendedAttribute) obj;
            String nm = ea.get("Name").toValue().toString();
            nm = nm.substring((FormNameEnum.FORM.getType() + ".").length());
            if (nm.indexOf(".") == -1) {
                attrId.setValue(nm);
                String value = ea.get("Value").toValue().toString();
                String[] vs = Utils.tokenize(value, ";");
                if (vs != null && vs.length >= 2) {
                    attrName.setValue(vs[0]);
                    attrDesc.setValue(vs[1]);
                }
            }
        }
    }
}
