/*
 * Created on 2004-2-23
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.form;

import javax.swing.JOptionPane;

import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLTablePanel;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 流程表单显示面板类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-2-23 14:30:44
 * @version 1.0
 */
public class XMLActivityFormPanel extends XMLTablePanel {

	/**
	 * Constructs XMLProcessFormPanel
	 * 
	 * @param myOwner
	 * @param title
	 * @param hasBorder
	 * @param automaticWidth
	 */
	public XMLActivityFormPanel(XMLCollection myOwner, String title,
			boolean hasBorder, boolean automaticWidth) {
		super(myOwner, title, hasBorder, automaticWidth);
	}

	protected void editElementDialog() {
		XMLComplexElement editElement = getSelectedElement();
		if (editElement != null) {
			XMLElementDialog de = new XMLElementDialog(getDialog(), editElement
					.toLabel()
					+ " - " + XMLUtil.getLanguageDependentString("EditingKey"));
			de.editXMLElement(editElement.getPanel(), true, false);
			if (!de.isCanceled()) {
				modifyElement(editElement);
				((XMLCollection) getOwner()).onElementModified(editElement);
			}
		} else {
			JOptionPane
					.showMessageDialog(
							getDialog(),
							XMLUtil
									.getLanguageDependentString("WarningEmptySelectionToEditOrDelete"),
									XMLUtil.getLanguageDependentString("Title"),
							JOptionPane.WARNING_MESSAGE);
		}
		getTable().requestFocus();
	}
}
