/*
 * Created on 2004-3-25
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.commonattribut;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import com.ds.config.BPDPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.Transition;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.util.XMLUtility;
import com.ds.config.PluginType;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 多选项扩展面板
 * </p>
 * <p>
 * Copyright: Copyright (c) 2007
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author liwz 2007-4-20 16:40:56
 * @version 1.0
 */
public class CommonMultiAttribute extends PluginElement {

	//public static  String COMMONATTRIBUTE_NAME = "COMMONMULTIATTRIBUTE";

	public static final String TYPE_NAME = "CUSTOMIZE";

	// 属性值以文本方式展示
	public static final int TEXTAREA_TYPE = 0;

	// 属性值以选择框方式展示
	public static final int CHECKBOX_TYPE = 1;
	
	private Map commonExMap=new HashMap();

	// 扩展属性集
	private XMLElement commonEAS;

	public CommonMultiAttribute(BPDPlugin plugin) {
		super(plugin);
		
		setLabelName(Message
				.getLanguageDependentString("ExtendedAttributes.display"));
		fillStructure();
	}

	protected void fillStructure() {
		super.fillStructure();
		
	}

	public void toXML(Node parent) {
	
		Element easElem = (Element) XMLUtility.getFirstChild(parent,
				"ExtendedAttributes");
		Document doc = parent.getOwnerDocument();
		if (easElem == null) {
			easElem = doc.createElement("ExtendedAttributes");
			parent.appendChild(easElem);
		}
	
		for (int k = 0; k < this.complexStructure.size(); k++) {
			
			XMLAttribute value=(XMLAttribute) complexStructure.get(k);
			Element elem = parent.getOwnerDocument().createElement(
					"ExtendedAttribute");			
			
			String nm = value.toValue().toString();
			Utils.toChildXML(easElem,this.getProperty("CommonMultiAttribute.key")+"."+value.toName().toString(),CommonMultiAttribute.TYPE_NAME,nm);
		}

	}
	

	public void afterImporting() throws PluginException { 	
		XMLComplexElement xce = null;
		if (getType().equals(PluginType.Process)) {
			Object obj = getProperty("Process");
			if (obj == null) {
				throw new PluginException(Message
						.getLanguageDependentString("Plugin.Initialize.Error"));
			}
			xce = (WorkflowProcess) obj;
		} else if (getType().equals(PluginType.Activity)) {
			Object obj = getProperty("Activity");
			if (obj == null) {
				throw new PluginException(Message
						.getLanguageDependentString("Plugin.Initialize.Error"));
			}
			xce = (Activity) obj;

		} else if (getType().equals(PluginType.Route)) {
			Object obj = getProperty("Route");
			if (obj == null) {
				throw new PluginException(Message
						.getLanguageDependentString("Plugin.Initialize.Error"));
			}
			xce = (Transition) obj;
		}
		ExtendedAttributes exAttrs = (ExtendedAttributes) xce
				.get("ExtendedAttributes");
		Set easToRemove = new HashSet();
		Iterator it = exAttrs.toCollection().iterator();
		String nm = "";
		String val = "";
		String type = "";
		//List commonExAttrs = new ArrayList();
		while (it.hasNext()) {
			ExtendedAttribute ea = (ExtendedAttribute) it.next();
			nm = ea.get("Name").toValue().toString();
			val = ea.get("Value").toValue().toString();
			type = ea.get("Type").toValue().toString();
			if (type.equalsIgnoreCase(CommonMultiAttribute.TYPE_NAME)) {
				easToRemove.add(ea);
				
				if (commonExMap.containsKey(nm)){
					XMLAttribute commonEx=(XMLAttribute) commonExMap.get(nm);
					commonEx.setValue(val);
				}
	
			}
		}
		exAttrs.toCollection().removeAll(easToRemove);
	
	}
	
	
//	 得到一般扩展属性显示的panel
	public XMLPanel getPanel() {

		XMLElement[] c = new XMLElement[complexStructure.size()];
		complexStructure.toArray(c);
		return new XMLGroupPanel(this, c, toLabel());
	}

	
	

	private XMLAttribute generateValueObject(int type, String val) {
		XMLAttribute attrValue = null;
		switch (type) {
		case CommonMultiAttribute.TEXTAREA_TYPE:
			attrValue = new XMLAttribute(val);
			attrValue.setRequired(true);
			break;
		case CommonMultiAttribute.CHECKBOX_TYPE:
			attrValue = new XMLAttribute(val, getElemValues(val), 0);
			break;
		}

		return attrValue;
	}
	
	
	// 得到属性值为CheckBox时选择范围
	private String[][] getElemValues(String val) {
		String elemName = (String) this.getProperty(val + ".SelectOption");
		String[] elemNames = Utils.tokenize(elemName, " ");
		String[][] values = new String[elemNames.length][2];
		for (int i = 0; i < values.length; i++) {
			String elem = elemNames[i];
			String[] elemValues = Utils.tokenize(elem, "|");
			values[i][0] = elemValues[1];
			values[i][1] = elemValues[0];
		}
		return values;
	}
	public void loadProperties() throws PluginException {
		this.setLabelName((String) this.getProperty("CommonMultiAttribute.LabelName"));		
		String configValue = (String) this.getProperty("ConfigOption");
		String[] configValues = Utils.tokenize(configValue, " ");
		String[][] names = new String[configValues.length][2];
		for (int i = 0; i < names.length; i++) {
			names[i][0] = (String) this.getProperty(configValues[i] + ".Name");
			names[i][1] = configValues[i];	
			XMLAttribute commonEx=new XMLAttribute(configValues[i]);
			String type = (String) this.getProperty(configValues[i] + ".Type");			
			commonEx = generateValueObject(Integer.parseInt(type), configValues[i]);					
			commonEx.setLabelName(names[i][0]);
			commonExMap.put(this.getProperty("CommonMultiAttribute.key")+"."+names[i][1],commonEx);
			complexStructure.add(commonEx);
		}
	}

}
