/*
 * Created on 2004-3-26
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.common;

import java.util.Vector;

import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLTablePanel;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 一般扩展属性展示面板类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-3-26 18:13:48
 * @version 1.0
 */
public class XMLCommonAttrPanel extends XMLTablePanel {

	/**
	 * @param myOwner
	 * @param title
	 * @param hasBorder
	 * @param automaticWidth
	 * @param miniDimension
	 */
	public XMLCommonAttrPanel(XMLCollection myOwner, String title,
			boolean hasBorder, boolean automaticWidth, boolean miniDimension) {
		super(myOwner, title, hasBorder, automaticWidth, miniDimension);
	}

	protected void editElementDialog() {
		XMLComplexElement editElement = getSelectedElement();
		if (editElement != null) {
			XMLElementDialog de = new XMLElementDialog(getDialog(), editElement
					.toLabel()
					+ " - " + XMLUtil.getLanguageDependentString("EditingKey"));
			// 控制属性名称不能修改
			editElement.get("Name").setReadOnly(true);
			de.editXMLElement(editElement.getPanel(), true, false);
			if (!de.isCanceled()) {
				modifyElement(editElement);
				((XMLCollection) getOwner()).onElementModified(editElement);
			}
		} else {
			JOptionPane
					.showMessageDialog(
							getDialog(),
							XMLUtil
									.getLanguageDependentString("WarningEmptySelectionToEditOrDelete"),
									XMLUtil.getLanguageDependentString("Title"),
							JOptionPane.WARNING_MESSAGE);
		}
		getTable().requestFocus();
	}

	protected void modifyElement(XMLComplexElement e) {
		JTable t = getTable();
		int row = t.getSelectedRow();
		DefaultTableModel dtm = (DefaultTableModel) t.getModel();
		Vector v = new Vector(((XMLComplexElement) e).toComplexTypeValues());
		// add object itself to the first column (it is invisible column)
		v.add(0, e);
		dtm.removeRow(row);
		dtm.insertRow(row, v);
		try {
			t.setRowSelectionInterval(row, row);
		} catch (Exception ex) {
		}
	}
}
