/*
 * Created on 2004-3-25
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.common;

import java.util.Iterator;
import java.util.List;

import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

import org.w3c.dom.Node;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 一般扩展属性集类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-3-25 14:52:13
 * @version 1.0
 */
public class CommonExAttributes extends XMLCollection {

	/**
	 * Construct a CommonExAttributes instance.
	 * 
	 * @param myOwner
	 */
	public CommonExAttributes(XMLComplexElement myOwner) {
		super(myOwner);
	}

	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		CommonExAttribute cea = new CommonExAttribute(this);
		cea.setRequired(true);
		return cea;
	}

	public XMLPanel getPanel() {
		controlledPanel = new XMLCommonAttrPanel(this, "", false, false, false);
		controlPanel = new XMLCommonAttrControlPanel(this, "", true, false);
		return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel,
				controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
	}

	public int[] getInvisibleTableFieldOrdinals() {
		return new int[] { 0 };
	}

	public void toXML(Node parent) {
		if (!isEmpty() || isRequired()) {
			if (parent != null) {
				for (Iterator it = refCollectionElements.iterator(); it
						.hasNext();) {
					((XMLElement) it.next()).toXML(parent);
				}
			}
		}
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		CommonExAttributes ceas = (CommonExAttributes) super.clone();
		return ceas;
	}

	public void afterImporting(List commonAttrs) {
		if (commonAttrs == null) {
			return;
		}
		for (int i = 0; i < commonAttrs.size(); i++) {
			ExtendedAttribute ea = (ExtendedAttribute) commonAttrs.get(i);
			CommonExAttribute cea = (CommonExAttribute) generateNewElement();
			add(cea);
			cea.afterImporting(ea);
		}
	}
}
