/*
 * Created on 2004-3-25
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.ds.config.BPDPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.Transition;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.common.util.XMLUtility;
import com.ds.config.PluginType;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 一般扩展属性插件
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * @version 1.0
 */
public class CommonAttribute extends PluginElement {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public static final String COMMONATTRIBUTE_NAME = "COMMON";

	public static final String TYPE_NAME = "CUSTOMIZE";

	// 属性值以文本方式展示
	public static final int TEXTAREA_TYPE = 0;

	// 属性值以选择框方式展示
	public static final int CHECKBOX_TYPE = 1;

	// 扩展属性集
	private XMLElement commonEAS;

	public CommonAttribute(BPDPlugin plugin) {
		super(plugin);
		commonEAS = new CommonExAttributes(this);
		// 初始化页面显示属性
		setLabelName(Message
				.getLanguageDependentString("ExtendedAttributes.display"));
		fillStructure();
	}

	protected void fillStructure() {
		super.fillStructure();
		complexStructure.add(commonEAS);
	}

	public void toXML(Node parent) {
		Element easElem = (Element) XMLUtility.getFirstChild(parent,
				"ExtendedAttributes");
		Document doc = parent.getOwnerDocument();
		if (easElem == null) {
			easElem = doc.createElement("ExtendedAttributes");
			parent.appendChild(easElem);
		}
		for (Iterator iter = complexStructure.iterator(); iter.hasNext();) {
			XMLElement element = (XMLElement) iter.next();
			element.toXML(easElem);
		}
	}

	public void afterImporting() throws PluginException {
		XMLComplexElement xce = null;
		if (getType().equals(PluginType.Process)) {
			Object obj = getProperty("Process");
			if (obj == null) {
				throw new PluginException(Message
						.getLanguageDependentString("Plugin.Initialize.Error"));
			}
			xce = (WorkflowProcess) obj;
		} else if (getType().equals(PluginType.Activity)) {
			Object obj = getProperty("Activity");
			if (obj == null) {
				throw new PluginException(Message
						.getLanguageDependentString("Plugin.Initialize.Error"));
			}
			xce = (Activity) obj;

		} else if (getType().equals(PluginType.Route)) {
			Object obj = getProperty("Route");
			if (obj == null) {
				throw new PluginException(Message
						.getLanguageDependentString("Plugin.Initialize.Error"));
			}
			xce = (Transition) obj;
		}
		ExtendedAttributes exAttrs = (ExtendedAttributes) xce
				.get("ExtendedAttributes");
		Set easToRemove = new HashSet();
		Iterator it = exAttrs.toCollection().iterator();
		String nm = "";
		String val = "";
		String type = "";
		List commonExAttrs = new ArrayList();
		while (it.hasNext()) {
			ExtendedAttribute ea = (ExtendedAttribute) it.next();
			nm = ea.get("Name").toValue().toString();
			val = ea.get("Value").toValue().toString();
			type = ea.get("Type").toValue().toString();
			if (type.equalsIgnoreCase(CommonAttribute.TYPE_NAME) && nm.indexOf("-")==-1 ) {
				easToRemove.add(ea);
				commonExAttrs.add(ea);
			}
		}
		exAttrs.toCollection().removeAll(easToRemove);
		((CommonExAttributes) commonEAS).afterImporting(commonExAttrs);
	}

	/**
	 * 实现clone方法
	 */
	public Object clone() {
		CommonAttribute ca = (CommonAttribute) super.clone();
		ca.commonEAS = (XMLElement) this.commonEAS.clone();
		ca.fillStructure();
		return ca;
	}
}
