/*
 * Created on 2004-3-9
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity.jdsform;

import javax.swing.JOptionPane;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLTablePanel;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 活动表单意见域显示面板类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-3-9 9:48:12
 * @version 1.0
 */
public class XMLOpinionPanel extends XMLTablePanel {

	/**
	 * Construct a XMLOpinionPanel instance.
	 * 
	 * @param myOwner
	 * @param title
	 * @param hasBorder
	 * @param automaticWidth
	 * @param miniDimension
	 */
	public XMLOpinionPanel(XMLCollection myOwner, String title,
			boolean hasBorder, boolean automaticWidth, boolean miniDimension) {
		super(myOwner, title, hasBorder, automaticWidth, miniDimension);
	}

	protected void editElementDialog() {
		if (BPD.getInstance().getUserInfo() == null) {
			return;
		}
		XMLComplexElement editElement = getSelectedElement();
		if (editElement != null) {
			XMLElement fields = editElement.get("OpinionFields");
			XMLElementDialog de = new XMLElementDialog(getDialog(), "'"
					+ editElement.get("Value").toValue().toString() + "' "
					+ fields.toLabel() + " - "
					+ XMLUtil.getLanguageDependentString("EditingKey"));
			de.editXMLElement(fields.getPanel(), true, false);
			if (!de.isCanceled()) {
				modifyElement(editElement);
				((XMLCollection) getOwner()).onElementModified(editElement);
			}
		} else {
			JOptionPane
					.showMessageDialog(
							getDialog(),
							XMLUtil
									.getLanguageDependentString("WarningEmptySelectionToEditOrDelete"),
									XMLUtil.getLanguageDependentString("Title"),
							JOptionPane.WARNING_MESSAGE);
		}
		getTable().requestFocus();
	}

}
