/*
 * Created on 2004-2-19
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity.jdsform;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTablePanel;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 活动表单显示面板类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-2-19 20:45:39
 * @version 1.0
 */
public class XMLActivityFormPanel extends XMLTablePanel {

	// 表格是否可配置编辑
	private boolean isEditable = false;

	// 表格可编辑的列
	private int[] editableColumns;

	Vector vector;

	public XMLActivityFormPanel(XMLCollection myOwner) {
		this(myOwner, "");

	}

	public XMLActivityFormPanel(XMLCollection myOwner, String title) {
		this(myOwner, title, true, false);
	}

	public XMLActivityFormPanel(XMLCollection myOwner, String title,
			boolean hasBorder, boolean automaticWidth) {
		this(myOwner, title, hasBorder, automaticWidth, false);
	}

	/**
	 * Constructs XMLActivityFormPanel
	 * 
	 * @param myOwner
	 * @param title
	 * @param hasBorder
	 * @param automaticWidth
	 * @param miniDimension
	 */
	public XMLActivityFormPanel(XMLCollection myOwner, String title,
			boolean hasBorder, boolean automaticWidth, boolean miniDimension) {
		this(myOwner, title, hasBorder, automaticWidth, miniDimension, false);
	}

	public XMLActivityFormPanel(XMLCollection myOwner, String title,
			boolean hasBorder, boolean automaticWidth, boolean miniDimension,
			boolean isEdit) {
		super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, true, hasBorder);
		this.isEditable = isEdit;
		this.editableColumns = myOwner.getEditableTableFieldOrdinals();
		// creating a table which do not allow cell editing
		Vector columnNames = new Vector();
		columnNames.add("Object");
		int noOfVisibleColumns = 0;

		Collection c = myOwner.getElementStructure();
		Iterator it = c.iterator();
		while (it.hasNext()) {
			XMLElement el = (XMLElement) it.next();
			columnNames.add(el.toLabel());
			noOfVisibleColumns++;
		}
		vector = new Vector();
		DefaultTableModel dtm = new DefaultTableModel(vector, columnNames) {

			public Class getColumnClass(int c) {
				return getValueAt(0, c).getClass();
			}

			public void fireTableCellUpdated(int row, int column) {
				if (((XMLCollection) getOwner()).isJCheckBox(column)) {
					for (int i = 0; i < getRowCount(); i++) {
						if (row != i) {
							((Vector) (vector.elementAt(i))).setElementAt(
									new Boolean(false), column);
						}
					}
				}
			}
		};
		JTable allItems = new JTable(dtm) {
			public boolean isCellEditable(int row, int col) {
				if (isEditable) {
					if (editableColumns != null && editableColumns.length > 0) {
						boolean isExisted = false;
						for (int i = 0; i < editableColumns.length; i++) {
							if (col == editableColumns[i]) {
								isExisted = true;
								break;
							}
						}
						return isExisted;
					} else {
						return false;
					}
				} else {
					return false;
				}
			}
		};

		int[] invisibleFieldOrdinals = myOwner.getInvisibleTableFieldOrdinals();

		TableColumnModel tcm = allItems.getColumnModel();
		TableColumn column;
		// setting the first column (object column) to be invisible
		column = allItems.getColumnModel().getColumn(0);
		column.setMinWidth(0);
		column.setMaxWidth(0);
		column.setPreferredWidth(0);
		column.setResizable(false);
		// setting fields that will not be displayed within the table
		if (invisibleFieldOrdinals != null && invisibleFieldOrdinals.length > 0) {
			noOfVisibleColumns -= invisibleFieldOrdinals.length;
			for (int i = 0; i < invisibleFieldOrdinals.length; i++) {
				column = allItems.getColumnModel().getColumn(
						invisibleFieldOrdinals[i] + 1);
				column.setMinWidth(0);
				column.setMaxWidth(0);
				column.setPreferredWidth(0);
				column.setResizable(false);
			}
		}

		// setting some table properties
		allItems.setColumnSelectionAllowed(false);
		allItems.setRowSelectionAllowed(true);
		allItems.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		allItems.getTableHeader().setReorderingAllowed(false);

		// fills Table
		it = myOwner.getTableElements().iterator();
		while (it.hasNext()) {
			XMLComplexElement elem = (XMLComplexElement) it.next();
			Vector v = new Vector(elem.toComplexValues());
			v.add(0, elem);
			dtm.addRow(v);
		}

		if (editableColumns != null && editableColumns.length > 0) {
			for (int i = 0; i < editableColumns.length; i++) {
				column = allItems.getColumnModel()
						.getColumn(editableColumns[i]);
				column.setCellEditor(myOwner
						.getEditableDefaultValue(editableColumns[i]));
			}
		}

		// mouse listener for editing on double-click
		allItems.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent me) {
				if (me.getClickCount() > 1 && !isEditable) {
					editElementDialog();
				}
			}
		});

		allItems.getInputMap(JComponent.WHEN_FOCUSED).put(
				KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0, false), "edit");
		allItems.getActionMap().put("edit", new AbstractAction() {
			public void actionPerformed(ActionEvent e) {
				if (!isEditable) {
					editElementDialog();
				}
			}
		});

		allItems.getInputMap(JComponent.WHEN_FOCUSED).put(
				KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, 0, false), "delete");
		allItems.getActionMap().put("delete", new AbstractAction() {
			public void actionPerformed(ActionEvent e) {
				if (!isEditable) {
					deleteElementDialog();
				}
			}
		});

		allItems.getInputMap(JComponent.WHEN_FOCUSED).put(
				KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false), "cancel");
		allItems.getActionMap().put("cancel", new AbstractAction() {
			public void actionPerformed(ActionEvent e) {
				XMLElementDialog d = ((XMLElementDialog) getDialog());
				d.setCanceled(true);
				d.dispose();
			}
		});

		// creates panel
		JScrollPane allItemsPane = new JScrollPane();
		allItemsPane.setViewportView(allItems);
		Dimension tDim;
		if (miniDimension) {
			tDim = new Dimension(miniTableDimension);
		} else if (noOfVisibleColumns <= 3) {
			tDim = new Dimension(smallTableDimension);
		} else if (noOfVisibleColumns <= 5) {
			tDim = new Dimension(mediumTableDimension);
		} else {
			tDim = new Dimension(largeTableDimension);
		}

		if (automaticWidth) {
			tDim.width = allItems.getPreferredScrollableViewportSize().width;
		}
		allItems.setPreferredScrollableViewportSize(new Dimension(tDim));

		add(allItemsPane);
		add(Box.createVerticalGlue());
	}

	protected void editElementDialog() {
		if (BPD.getInstance().getUserInfo() == null) {
			return;
		}
		XMLComplexElement editElement = getSelectedElement();
		if (editElement != null) {
			XMLElement fields = editElement.get("FormFields");
			XMLElementDialog de = new XMLElementDialog(getDialog(), "'"
					+ editElement.get("Value").toValue().toString() + "' "
					+ fields.toLabel() + " - "
					+ XMLUtil.getLanguageDependentString("EditingKey"));
			de.editXMLElement(fields.getPanel(), true, false);
			if (!de.isCanceled()) {
				modifyElement(editElement);
				((XMLCollection) getOwner()).onElementModified(editElement);
			}
		} else {
			JOptionPane
					.showMessageDialog(
							getDialog(),
							XMLUtil
									.getLanguageDependentString("WarningEmptySelectionToEditOrDelete"),
									XMLUtil.getLanguageDependentString("Title"),
							JOptionPane.WARNING_MESSAGE);
		}
		getTable().requestFocus();
	}

	public void setElements() {
		if (isEditable) {
			DefaultTableModel dtm = (DefaultTableModel) getTable().getModel();
			Iterator it = ((XMLCollection) getOwner()).getTableElements()
					.iterator();
			int row = 0;
			while (it.hasNext()) {
				XMLComplexElement elem = (XMLComplexElement) it.next();
				Collection complexStructure = elem.toComplexType();
				int col = 1;
				for (Iterator iter = complexStructure.iterator(); iter
						.hasNext();) {
					XMLElement xmlElem = (XMLElement) iter.next();
					Object obj = dtm.getValueAt(row, col);
					if (obj instanceof XMLSelectOption) {
						xmlElem.setValue(((XMLSelectOption) obj));
					} else if (obj instanceof Boolean) {
						xmlElem.setValue(((Boolean) obj).toString());
					} else {
						xmlElem.setValue(obj);
					}
					col++;
				}
				row++;
			}
		}
	}

	public boolean isValidEnter() {
		boolean isExisted = false;
		DefaultTableModel dtm = (DefaultTableModel) getTable().getModel();
		XMLCollection owner = (XMLCollection) getOwner();
		int[] editableColumns = owner.getEditableTableFieldOrdinals();
		for (int i = 0; i < dtm.getRowCount(); i++) {
			if (editableColumns != null && editableColumns.length > 0) {
				for (int j = 0; j < editableColumns.length; j++) {
					int column = editableColumns[j];
					if (owner.isJCheckBox(column)
							&& dtm.getValueAt(i, column) instanceof Boolean) {
						if (((Boolean) dtm.getValueAt(i, column))
								.booleanValue()) {
							isExisted = true;
							break;
						}
					}
				}
			}
		}
		if (dtm.getRowCount() == 0) {
			isExisted = true;
		}
		return isExisted;
	}

	protected void modifyElement(XMLComplexElement e) {
		JTable t = getTable();
		int row = t.getSelectedRow();
		DefaultTableModel dtm = (DefaultTableModel) t.getModel();
		Vector v = new Vector(((XMLComplexElement) e).toComplexValues());
		// add object itself to the first column (it is invisible column)
		v.add(0, e);
		dtm.removeRow(row);
		dtm.insertRow(row, v);
		try {
			t.setRowSelectionInterval(row, row);
		} catch (Exception ex) {
		}
	}

}
