/*
 * Created on 2004-3-4
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity.jdsform;

import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.config.BPDPlugin;
import com.ds.config.CParameter;

import java.util.*;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 活动表单中WebWord插件
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-3-4 15:41:49
 * @version 1.0
 */
public class WebWord extends PluginElement {

	public static final String WEBWORD_NAME = "WebWord";

	public static final String APPLICATION_NAME = "APPLICATION";

	private XMLElement webWordButtons;

	// 活动对象
	private Activity act;

	// 流程对象
	private WorkflowProcess wp;

	/**
	 * Construct a WebWord instance.
	 */
	public WebWord(BPDPlugin plugin) {
		super(plugin);
		webWordButtons = new WebWordButtons(this);
		setLabelName(Message
				.getLanguageDependentString("Activity.WebWord.display"));
		fillStructure();
	}

	protected void fillStructure() {
		complexStructure.add(webWordButtons);
	}

	public Object clone() {
		WebWord ww = (WebWord) super.clone();
		ww.webWordButtons = (XMLElement) this.webWordButtons.clone();
		ww.fillStructure();
		return ww;
	}

	// 获取WebWord的按钮显示名称和按钮代码
	public String[][] getButtons() {
		Object obj = wp.getProperty("WebWordButtons");
		if (obj != null) {
			return (String[][]) obj;
		}
		String[][] buttons = null;
		String strButtonNames = Message
				.getLanguageDependentString("Activity.WebWord.Button.name");
		String[] array_bns = Utils.tokenize(strButtonNames, " ");
		String strButtonCodes = Message
				.getLanguageDependentString("Activity.WebWord.Button.code");
		String[] array_bcs = Utils.tokenize(strButtonCodes, " ");
		if (array_bns.length != array_bcs.length) {
			return buttons;
		}

		Map<String, CParameter> parameterMap = this.getBpdElement().getParameters();
		Set<String> paramKey = parameterMap.keySet();
		buttons = new String[array_bns.length][paramKey.size()];
		int k = 0;
		for (String paramName : paramKey) {
			buttons[k][0] = paramName;
			buttons[k][1] = parameterMap.get(paramName).getDesc();
			k++;
		}

//		buttons = new String[array_bns.length][2];
//		for (int i = 0; i < array_bns.length; i++) {
//			String name = array_bns[i];
//			String code = array_bcs[i];
//			buttons[i][0] = code;
//			buttons[i][1] = name;
//		}
//



		wp.setProperty("WebWordButtons", buttons);
		return buttons;
	}

	// 获取WebWord操作状态
	public String[][] getOperationState() {
		Object obj = wp.getProperty("WebWordButtonState");
		if (obj != null) {
			return (String[][]) obj;
		}
		String[][] states = new String[][] { { "不可用", "0" }, { "可用", "1" } };
		wp.setProperty("WebWordButtonState", states);
		return states;
	}

	public void loadProperties() throws PluginException {
		Object obj = getProperty("Activity");
		if (obj == null) {
			throw new PluginException(Message
					.getLanguageDependentString("Plugin.Initialize.Error"));
		}
		act = (Activity) obj;
		Object wpObj = getProperty("WorkflowProcess");
		if (wpObj == null) {
			throw new PluginException(Message
					.getLanguageDependentString("Plugin.Initialize.Error"));
		}
		wp = (WorkflowProcess) wpObj;
	}

	// 从活动扩展属性保存到WebWord对象
	public void afterImporting() throws PluginException {
		ExtendedAttributes exAttrs = (ExtendedAttributes) act
				.get("ExtendedAttributes");
		Set easToRemove = new HashSet();
		Iterator it = exAttrs.toCollection().iterator();
		String nm = "";
		String val = "";
		List buttons = new ArrayList();
		while (it.hasNext()) {
			ExtendedAttribute ea = (ExtendedAttribute) it.next();
			nm = ea.get("Name").toValue().toString();
			val = ea.get("Value").toValue().toString();
			if (nm.startsWith(WebWord.WEBWORD_NAME)) {
				easToRemove.add(ea);
				if (!nm.equalsIgnoreCase(WebWord.WEBWORD_NAME)) {
					buttons.add(ea);
				}
			}
		}
		exAttrs.toCollection().removeAll(easToRemove);
		((WebWordButtons) webWordButtons).afterImporting(buttons);
	}
}
