/*
 * Created on 2004-3-4
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity.jdsform;

import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.plugin.impl.activity.Message;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.config.BPDPlugin;
import com.ds.config.CParameter;

import java.util.*;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 活动表单中Attachment插件
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 *
 * @author Huchm 2004-3-4 15:41:49
 * @version 1.0
 */
public class Attachment extends PluginElement {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    public static final String ATTACHMENT = "Attachment";

    public static final String APPLICATION_NAME = "APPLICATION";

    private XMLElement attachmentButtons;

    // 活动对象
    private Activity act;

    // 流程对象
    private WorkflowProcess wp;

    /**
     * Construct a Attachment instance.
     */
    public Attachment(BPDPlugin plugin) {
        super(plugin);
        attachmentButtons = new AttachmentButtons(this);
        setLabelName(Message
                .getLanguageDependentString("Activity.Attachment.display"));
        fillStructure();
    }

    protected void fillStructure() {
        complexStructure.add(attachmentButtons);
    }

    public Object clone() {
        Attachment ww = (Attachment) super.clone();
        ww.attachmentButtons = (XMLElement) this.attachmentButtons.clone();
        ww.fillStructure();
        return ww;
    }

    // 获取Attachment的按钮显示名称和按钮代码
    public String[][] getButtons() {
        Object obj = wp.getProperty("AttachmentButtons");
        if (obj != null) {
            return (String[][]) obj;
        }
        String[][] buttons = null;
        String strButtonNames = Message
                .getLanguageDependentString("Activity.Attachment.Button.name");
        String[] array_bns = Utils.tokenize(strButtonNames, " ");
        String strButtonCodes = Message
                .getLanguageDependentString("Activity.Attachment.Button.code");
        String[] array_bcs = Utils.tokenize(strButtonCodes, " ");
        if (array_bns.length != array_bcs.length) {
            return buttons;
        }

        Map<String, CParameter> parameterMap = this.getBpdElement().getParameters();
        Set<String> paramKey = parameterMap.keySet();
        buttons = new String[array_bns.length][paramKey.size()];
        int k = 0;
        for (String paramName : paramKey) {
            buttons[k][0] = paramName;
            buttons[k][1] = parameterMap.get(paramName).getDesc();
            k++;
        }
        wp.setProperty("AttachmentButtons", buttons);
        return buttons;
    }

    // 获取Attachment操作状态
    public String[][] getOperationState() {
        Object obj = wp.getProperty("AttachmentButtonState");
        if (obj != null) {
            return (String[][]) obj;
        }
        String[][] states = new String[][]{{"不可用", "0"}, {"可用", "1"}};
        wp.setProperty("AttachmentButtonState", states);
        return states;
    }

    public void loadProperties() throws PluginException {
        Object obj = getProperty("Activity");
        if (obj == null) {
            throw new PluginException(Message
                    .getLanguageDependentString("Plugin.Initialize.Error"));
        }
        act = (Activity) obj;
        Object wpObj = getProperty("WorkflowProcess");
        if (wpObj == null) {
            throw new PluginException(Message
                    .getLanguageDependentString("Plugin.Initialize.Error"));
        }
        wp = (WorkflowProcess) wpObj;
    }

    // 从活动扩展属性保存到Attachment对象
    public void afterImporting() throws PluginException {
        ExtendedAttributes exAttrs = (ExtendedAttributes) act
                .get("ExtendedAttributes");
        Set easToRemove = new HashSet();
        Iterator it = exAttrs.toCollection().iterator();
        String nm = "";
        String val = "";
        List buttons = new ArrayList();
        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute) it.next();
            nm = ea.get("Name").toValue().toString();
            val = ea.get("Value").toValue().toString();
            if (nm.startsWith(Attachment.ATTACHMENT)) {
                easToRemove.add(ea);
                if (!nm.equalsIgnoreCase(Attachment.ATTACHMENT)) {
                    buttons.add(ea);
                }
            }
        }
        exAttrs.toCollection().removeAll(easToRemove);
        ((AttachmentButtons) attachmentButtons).afterImporting(buttons);
    }
}
