/*
 * Created on 2004-3-4
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity.buttons;

import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.plugin.impl.activity.Message;
import com.ds.bpm.bpd.plugin.impl.activity.jdsform.Attachment;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.config.BPDPlugin;

import java.util.*;

public class ButtonPlugin extends PluginElement {

    /**
     *
     */
    private static final long serialVersionUID = 1L;


    private XMLElement activityButtons;

    // 活动对象
    private Activity act;

    // 流程对象
    private WorkflowProcess wp;

    /**
     * Construct a Attachment instance.
     */
    public ButtonPlugin(BPDPlugin plugin) {
        super(plugin);
        activityButtons = new ActivityButtons(this);

        fillStructure();
    }

    protected void fillStructure() {

        setLabelName("常用按钮");
        complexStructure.add(activityButtons);
    }

    public Object clone() {
        ButtonPlugin ww = (ButtonPlugin) super.clone();
        ww.activityButtons = (XMLElement) this.activityButtons.clone();
        ww.fillStructure();
        return ww;
    }


    // 获取Attachment操作状态
    public String[][] getOperationState() {
        Object obj = wp.getProperty("ActivityButtonState");
        if (obj != null) {
            return (String[][]) obj;
        }
        String[][] states = new String[][]{{"动态选择", "auto"}, {"强制禁止", "false"}, {"强制启用", "true"}};
        wp.setProperty("ActivityButtonState", states);
        return states;
    }

    public void loadProperties() throws PluginException {
        Object obj = getProperty("Activity");
        if (obj == null) {
            throw new PluginException(Message
                    .getLanguageDependentString("Plugin.Initialize.Error"));
        }
        act = (Activity) obj;
        Object wpObj = getProperty("WorkflowProcess");
        if (wpObj == null) {
            throw new PluginException(Message
                    .getLanguageDependentString("Plugin.Initialize.Error"));
        }
        wp = (WorkflowProcess) wpObj;
    }

    // 从活动扩展属性保存到Attachment对象
    public void afterImporting() throws PluginException {
        ExtendedAttributes exAttrs = (ExtendedAttributes) act
                .get("ExtendedAttributes");
        Set easToRemove = new HashSet();
        Iterator it = exAttrs.toCollection().iterator();
        String nm = "";
        String val = "";
        List buttons = new ArrayList();
        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute) it.next();
            nm = ea.get("Name").toValue().toString();
            val = ea.get("Value").toValue().toString();
            if (nm.startsWith(Attachment.ATTACHMENT)) {
                easToRemove.add(ea);
                if (!nm.equalsIgnoreCase(Attachment.ATTACHMENT)) {
                    buttons.add(ea);
                }
            }
        }
        exAttrs.toCollection().removeAll(easToRemove);
        ((ActivityButtons) activityButtons).afterImporting(buttons);
    }
}
