/*
 * Created on 2004-2-25
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.ds.config.BPDPlugin;
import com.ds.esb.config.formula.FormulaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ds.bpm.bpd.enums.DeviceDefEventEnums;
import com.ds.bpm.bpd.plugin.ExpressionElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.formula.Formulas;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.enums.EnumsUtil;

/**
 * <p>
 * Title: ISD设计工具（BPD）
 * </p>
 * <p>
 * Description: 选择执行设备
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author 文章 2018-1-5 14:13:32
 * @version 3.0
 */
public class SimpleActivityDeviceEvent extends ExpressionElement {

    private Formulas performSelected = new Formulas(this, FormulaType.DeviceSelectedID);

    private XMLAttribute eventType = new XMLAttribute(EnumsUtil.getAttribute(DeviceDefEventEnums.DeviceAPIEventEnums));

    public SimpleActivityDeviceEvent(BPDPlugin plugin) {
	super(plugin);
	fillStructure();
    }

    protected void fillStructure() {
	super.fillStructure();
	complexStructure.add(eventType);
	complexStructure.add(performSelected);

    }

    // 把活动办理权限信息保存在XML文件中
    public void toXML(Node parent) {
	NodeList nodeList = ((Element) parent).getElementsByTagName("ExtendedAttributes");
	Element easElem;
	Document doc = parent.getOwnerDocument();
	if (nodeList.getLength() != 0) {
	    easElem = (Element) nodeList.item(0);
	} else {
	    easElem = doc.createElement("ExtendedAttributes");
	    parent.appendChild(easElem);
	}
	for (Iterator iter = complexStructure.iterator(); iter.hasNext();) {
	    XMLElement element = (XMLElement) iter.next();
	    if (element instanceof Formulas) {
		element.toXML(easElem);
	    } else {
		Element eaElem = doc.createElement("ExtendedAttribute");
		eaElem.setAttribute("Type", "DeviceEvent");
		eaElem.setAttribute("Name", element.toName());
		eaElem.setAttribute("Value", element.toValue().toString());
		easElem.appendChild(eaElem);
	    }
	}

    }

    // 从活动扩展属性保存到活动权限对象
    public void afterImporting() throws PluginException {
	Object obj = getProperty("Activity");
	if (obj != null) {
		act = (Activity) obj;
		ExtendedAttributes exAttrs = (ExtendedAttributes) act.get("ExtendedAttributes");
		Set easToRemove = new HashSet();
		Iterator it = exAttrs.toCollection().iterator();
		String nm = "";
		String val = "";
		List performerSelectedList = new ArrayList();

		while (it.hasNext()) {
		    ExtendedAttribute ea = (ExtendedAttribute) it.next();
		    nm = ea.get("Name").toValue().toString();
		    val = ea.get("Value").toValue().toString();
		    if (nm.startsWith("DEVICEEVENTSELECTEDID".toUpperCase())) {
			performerSelectedList.add(ea);
			easToRemove.add(ea);
			continue;
		    }

		    if (nm.equalsIgnoreCase("DeviceEvent")) {
			eventType.setValue(val);
			easToRemove.add(ea);
			continue;
		    }

		}

		performSelected.afterImporting(performerSelectedList);

		exAttrs.toCollection().removeAll(easToRemove);
	    //throw new PluginException(Message.getLanguageDependentString("Plugin.Initialize.Error"));
	}
	
    }

    public void setLabelName() {
	// 初始化页面显示属性
	setLabelName(this.getBpdElement().getDisplayname());
	
    }

    public Object clone() {
	SimpleActivityDeviceEvent ar = (SimpleActivityDeviceEvent) super.clone();
	ar.eventType = (XMLAttribute) this.eventType.clone();
	ar.performSelected = (Formulas) this.performSelected.clone();

	ar.fillStructure();
	return ar;
    }

    public XMLPanel getPanel() {

	XMLPanel commonPanel = new XMLGroupPanel(this, new XMLElement[] { eventType, performSelected }, "网关API监听");

	return new XMLTabbedPanel(this, new XMLPanel[] { commonPanel });
    }
}
